unit GraphQue;
{$IFDEF FPC}
  {$MODE DELPHI}{$H+}
{$ENDIF}
interface
uses
  Classes, SysUtils;

procedure GraphOutExec;
Type
  TGraphCommand=Class
      procedure execute ;virtual;abstract;
  end;

  TGraphCommand2=class(TGraphCommand)
     prev:TGraphCommand;
     constructor create(p:TGraphCommand);overload;
     destructor destroy;override;
  end;

type
  pBoolean=^Boolean;
  TReSetBoolean=class(TGraphCommand)
    s:pBoolean;
    constructor create(var b:boolean);
    procedure execute;override;
  end;

procedure AddQueue(s:TGraphCommand);

implementation
uses base,base2,affine,graphsys;

constructor TGraphCommand2.create(p:TGraphCommand);
begin
   inherited create;
   prev:=p;
  end;

destructor TGraphCommand2.destroy;
begin
    if prev<>nil then prev.free;
    inherited destroy;
  end;

constructor TReSetBoolean.create(var b:boolean);
begin
  inherited create;
  s:=@b;
end;

procedure TReSetBoolean.execute;
begin
  s^:=false;
end;

var
queue:array[0..65535]of TGraphCommand;
point0:word=0;
point1:word=0;

procedure GraphOutExec;
var
  p0:word;
begin
   p0:=point0;
   //if point1<>p0 then
     // RepaintRequest:=true;
   while point1<>p0 do
   begin
      with queue[point1] do
         begin
            execute;
            free;
         end;
      inc(point1);
   end;
end;

var AddQueueCriticalSection: TRTLCriticalSection;
procedure AddQueue(s:TGraphCommand);
begin
    EnterCriticalSection(AddQueueCriticalSection);
    while word(point0+1)=point1 do (TThread.CurrentThread).Yield;
    queue[point0]:=s;
    inc(point0);
    LeaveCriticalSection(AddQueueCriticalSection);
end;

initialization
InitCriticalSection(AddQueueCriticalSection);


finalization
DoneCriticalSection(AddQueueCriticalSection);



end.

