unit GraphOpt;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  OKCANCL2, StdCtrls, ExtCtrls, ComCtrls, Spin;


type
  TGraphOptDlg = class(TOKRightDlg)
    HelpBtn: TButton;
    RadioGroup1: TRadioGroup;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    PrinterSetupDialog1: TPrinterSetupDialog;
    Label1: TLabel;
    TrackBar1: TTrackBar;
    Label2: TLabel;
    Label3: TLabel;
    RadioGroup2: TRadioGroup;
    Label4: TLabel;
    Label5: TLabel;
    SpinEdit1: TSpinEdit;
    SpinEdit2: TSpinEdit;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    procedure HelpBtnClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private 錾 }
  public
    procedure execute;
  end;

var
  GraphOptDlg: TGraphOptDlg;

implementation

uses printers,
     GraphSys,Paintfrm,METADLG, MDIFrame;
{$R *.dfm}

procedure TGraphOptDlg.execute;
begin
    RadioGroup1.ItemIndex:=byte(NextGraphMode);
    RadioGroup2.ItemIndex:=byte(alignTop);
    TrackBar1.Position:=AdditionalMargin;
    SpinEdit1.Value:=MymmWidth div 1000;
    SpinEdit2.Value:=MymmHeight div 1000;

    if ShowModal=mrOk then
       begin
         byte(NextGraphMode):=RadioGroup1.ItemIndex;
         byte(AlignTop):=RadioGroup2.ItemIndex;
         AdditionalMargin:=TrackBar1.Position;
         MymmWidth:=SpinEdit1.Value * 1000;
         MymmHeight:=SpinEdit2.Value * 1000;
       end;
end;

procedure TGraphOptDlg.HelpBtnClick(Sender: TObject);
begin
  Application.HelpContext(HelpContext);
end;

procedure TGraphOptDlg.Button1Click(Sender: TObject);
begin
  inherited;
  paintform.Font1Click(Sender);
end;

procedure TGraphOptDlg.Button2Click(Sender: TObject);
begin
  inherited;
   with paintform do
    begin
      FontDialog1.Font.Assign(MetaFileFont);
      if FontDialog1.execute then
          MetaFileFont.Assign(FontDialog1.Font);
    end;
end;

procedure TGraphOptDlg.Button3Click(Sender: TObject);
begin
  inherited;
  PrinterSetupDialog1.Execute;
end;

procedure TGraphOptDlg.RadioGroup1Click(Sender: TObject);
begin
  inherited;
  with RadioGroup1 do
  case itemindex of
   0:
    begin
    Button1.enabled:=true;
    Button2.enabled:=false;
    Button3.enabled:=false;
    Label1.enabled:=false;
    TrackBar1.enabled:=false;
    Label2.enabled:=false;
    Label3.enabled:=false;
    Label4.enabled:=false;
    Label5.enabled:=false;
    RadioGroup2.enabled:=false;
    SpinEdit1.enabled:=false;
    SpinEdit2.enabled:=false;
    Label6.enabled:=false;
    Label7.enabled:=false;
    Label8.enabled:=false;
    Label9.enabled:=false;
    end;
   1:
    begin
    Button1.enabled:=false;
    Button2.enabled:=true;
    Button3.enabled:=true;
    Label1.enabled:=false;
    TrackBar1.enabled:=false;
    Label2.enabled:=false;
    Label3.enabled:=false;
    Label4.enabled:=false;
    Label5.enabled:=false;
    RadioGroup2.enabled:=false;
    SpinEdit1.enabled:=true;
    SpinEdit2.enabled:=true;
    Label6.enabled:=true;
    Label7.enabled:=true;
    Label8.enabled:=true;
    Label9.enabled:=true;
    end;
    2..3:
    begin
    Button1.enabled:=false;
    Button2.enabled:=true;
    Button3.enabled:=true;
    Label1.enabled:=true;
    TrackBar1.enabled:=true;
    Label2.enabled:=true;
    Label3.enabled:=true;
    Label4.enabled:=true;
    Label5.enabled:=true;
    RadioGroup2.enabled:=true;
    SpinEdit1.enabled:=false;
    SpinEdit2.enabled:=false;
    Label6.enabled:=false;
    Label7.enabled:=false;
    Label8.enabled:=false;
    Label9.enabled:=false;
    end;
  end;
end;

procedure TGraphOptDlg.Button4Click(Sender: TObject);
begin
  inherited;
  MetaFileDlg.execute
end;

procedure TGraphOptDlg.FormCreate(Sender: TObject);
begin
  inherited;
     // v^L̃eXg
  try
    if (printer.Handle=0) then
        RadioGroup1.Enabled:=false;
  except
        RadioGroup1.Enabled:=false;
  end;

end;

end.

