unit BASini;

{$MODE delphi}{$H+}

interface

uses
 Classes, SysUtils,
 Forms, LResources;

  procedure init;
  procedure finish;

implementation
uses base,
 paintfrm in 'paintfrm.pas',
 TextFrm in 'textfrm.pas',
 locatefrm in 'locatefrm.pas',
 locatech in 'locatech.pas' {LocateChoice},
 inputdlg in 'inputdlg.pas',
 charinp in 'charinp.pas',
 debugdg in 'debugdg.pas',
 sconsts,base2,arithmet,math2sub,textfile,graphsys;

 procedure CreateFormsT;
 begin

  Application.CreateForm(TTextForm, TextForm);
  Application.CreateForm(TPaintForm, PaintForm);
  Application.CreateForm(TLocateForm, LocateForm);
  Application.CreateForm(TLocateChoiceForm, LocateChoiceForm);
  Application.CreateForm(TInputDialog, InputDialog);
  Application.CreateForm(TCharInput, CharInput);
  Application.CreateForm(TDebugDlg, DebugDlg);

 end;

 procedure CreateFormsG;
 begin

  Application.CreateForm(TPaintForm, PaintForm);
  Application.CreateForm(TTextForm, TextForm);
  Application.CreateForm(TLocateForm, LocateForm);
  Application.CreateForm(TLocateChoiceForm, LocateChoiceForm);
  Application.CreateForm(TInputDialog, InputDialog);
  Application.CreateForm(TCharInput, CharInput);
  Application.CreateForm(TDebugDlg, DebugDlg);

end;

{**********}
{Initialize}
{**********}

procedure SetExecutingNow(s:boolean);
begin
   ExecutingNow:=s;
   with TextForm  do begin
       Break1.enabled:=s;
       File1.enabled:=not s;
       Edit1.enabled:=not s;
       option1.enabled:=not s;
       PopupMenu1.AutoPopup:=not s; //LCLでは無効？
       cut2.enabled:=not s;
       paste2.enabled:=not s;
       delete2.enabled:=not s;
   end;
   with PaintForm do begin
       break1.enabled:=s;
       File1.enabled:=not s;
       Edit1.enabled:=not s;
       //option1.enabled:=not s;
   end;
end;

var
  StartingTime:TDateTime;

 procedure init;
begin
    if GraphMode then
      CreateFormsG
    else
      CreateFormsT;

   arithmet.signiwidth:=base.min(signiwidth0, arithmet.places);
   InitSeed;

  //statusmes.clear;
  if AppName='' then
    TextForm.Caption:=s_DefaultAppName
  else
     TextForm.caption:=ExtractFileName(AppName);
  PaintForm.Caption:=TextForm.Caption;

  console:=TConsole.create ;
  LocalPrinter:=TLocalPrinter.create;
  TextForm.memo1.Enabled:=true;

  if textmode then
     textForm.show;
   if UseCharInput then
    begin
       charinput.init;
   end;

  SetExecutingNow(true);

  GraphSys.TextProblemCoordinate:=TextProblemCoordinate;
  LocateForm.InitValue;
  if graphmode  then
       begin
          PaintForm.Caption:=TextForm.Caption;
          InitGraphics;
          PaintForm.Visible:=true;
          PaintForm.WindowState:=wsNormal;
          PaintForm.BringToFront;
          ScreenBMPGraphSys.SetUp;
          PaintForm.setsize2;
          if textmode
            and (paintform.left<textform.left) and (paintform.top<textform.top)
            and (textform.Left+textform.Width<paintform.Left+paintform.Width)
            and (textform.Top+textform.Height<paintform.Top+paintform.Height) then
            begin
              textform.left:=base.max(0,paintform.left -80);
              textform.top:=base.max(0,paintform.top -40);
            end
      end
   else
       PaintForm.Visible:=false;


   Application.ProcessMessages;
  {$IFDEF Darwin}
  SetCurrentDir(ExtractFileDir(AppName));
  {$ENDIF}
   StartingTime:=Now;
end;


 procedure finish;
 var
   ExecTime:string;
 begin
   ExecTime:=FloatToStrF( (Now-StartingTime)*24*60*60, ffFixed,15,2);
   TextForm.StatusBar1.Panels[1].text:='Finished.  Execution Time '+ ExecTime+'s';
   PaintForm.StatusBar1.Panels[2].text:='Finished.  Execution Time '+ ExecTime+'s';
   SetExecutingNow(false);
   MyGraphSys.finish;
   console.free;
   LocalPrinter.free;
   TextForm.memo1.Enabled:=true;
   If TextMode then
      TextForm.Visible:=true;
   Application.ProcessMessages;
 end;

initialization

end.

