unit mathlib0;
{$IFDEF FPC}
  {$MODE DELPHI}{$H+}
{$ENDIF}
{$INLINE ON}
(***************************************)
(* Copyright (C) 2014, SHIRAISHI Kazuo *)
(***************************************)

interface
uses
  Classes, SysUtils,math;

function REMAINDER( x,y:double):double;inline;overload;
function ACOSDEG( x:double):double;   inline;overload;
function ASINDEG( x:double):double;   inline;overload;
function ANGLE( x,y:double):double;   inline;overload;
function ANGLEDEG( x,y:double):double;inline;overload;
function LOG( x:double):double;       inline;overload;
function Power( x,y:double):double;   inline;overload;

const
   DefaultExcode=$00000000; // Extypeを報告させない

implementation
uses
     base,base2,math2sub,baslib;


function REMAINDER(x,y:double):double;inline;
begin
   result:=x-y*system.int(x/y);
end;




function ACOSDEG( x:double):double;inline;
begin
    result:= acos(x)*degree
end;

function ASINDEG( x:double):double;inline;
begin
    result:= asin(x)*degree
end;

function ANGLE( x,y:double):double;inline;
begin
      result:=ArcTan2(y,x)
end;

function ANGLEdeg( x,y:double):double;inline;
begin
   result:=ANGLE(x,y)*degree
end;

function LOG( x:double):double;inline;
begin
    result:=ln(x);
end;

function Power( x,y:double):double; inline;
begin
   result:=math.Power(x,y)
end;



initialization
excode:=DefaultExcode;
end.

