﻿unit about;

{$IFDEF FPC}
  {$MODE DELPHI}{$H+}
{$ENDIF}

(***************************************)
(* Copyright (C) 2018, SHIRAISHI Kazuo *)
(***************************************)


interface

uses  Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ComCtrls, ExtCtrls, LResources;

type

  { TAboutBox }

  TAboutBox = class(TForm)
    Label1: TLabel;
    Web: TLabel;
    Panel1: TPanel;
    OKButton: TBitBtn;
    ProductName: TLabel;
    Copyright: TLabel;
    Comments: TLabel;
    Memo1: TMemo;
    version: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure Label1Click(Sender: TObject);
    procedure WebClick(Sender: TObject);
  private
    { Private 宣言 }
  public
    { Public 宣言 }
  end;

var
  AboutBox: TAboutBox;


implementation
uses
  LCLVersion,{$IFDEF Windows}windows,shellapi{$ELSE}Unix,LCLIntf{$ENDIF};


{$R *.lfm}

procedure TAboutBox.FormCreate(Sender: TObject);
begin
   version.Caption:='Version 2.1.3.2'   ;
   Web.Font.Color:=clBlue;
   {$IFDEF LCLGTK2}
    memo1.enabled:=false;
   {$ENDIF}
end;

procedure OpenWeb(s:string);
begin
  {$IFDEF windows}
     ShellExecuteA(AboutBox.Handle,'Open',PChar(s), '','',SW_SHOW);
  {$ELSE}
    {$IFDEF Darwin}
     OpenURL(s);
    {$ELSE}
     OpenURL(s);
    {$ENDIF}
  {$ENDIF}
  end;


procedure TAboutBox.Label1Click(Sender: TObject);
begin
  OpenWeb('https://osdn.net/projects/decimalbasic/forums/16171/')
end;


procedure TAboutBox.WebClick(Sender: TObject);
begin
   OpenWeb('http://hp.vector.co.jp/authors/VA008683/english/PractBASIC.htm')
end;



initialization



end.

