unit debugdg;

{$IFDEF FPC}
  {$MODE DELPHI}{$H+}
{$ENDIF}

(***************************************)
(* Copyright (C) 2003, SHIRAISHI Kazuo *)
(***************************************)


interface

uses  Classes, Graphics, Forms, Controls, Buttons,
   LResources, StdCtrls, ExtCtrls, ComCtrls, Dialogs,
   SysUtils, LCLIntf;

type TShowResult=(srNone,srOK,srCancel);


type
  TDebugDlg = class(TForm)
    OKBtn: TBitBtn;
    Label2: TLabel;
    cancel1: TBitBtn;
    procedure OKBtnClick(Sender: TObject);
    procedure cancel1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
     sr:TShowResult;
     Label0:string;
     Pause:boolean;
  public
     ShowResult:TShowresult;
     procedure execute;
     procedure initBreak(s:string);
     procedure initPause(s:string);

  end;

var
  DebugDlg: TDebugDlg;
procedure BreakPr(s:string);
procedure Pause(s:string);

implementation
uses
     base, base2, paintfrm, textfrm, baslib;
{$R *.lfm}


procedure TDebugDlg.initBreak(s:string);
begin
     Label0:=s;
     Pause:=false;


end;
procedure TDebugDlg.initPAUSE(s:string);
begin
    Label0:=s;
    Pause:=true;


end;

procedure SwitchMenues(s:boolean);
begin
   paintform.File1.Enabled:=s;
   paintform.Edit1.Enabled:=s;
   paintform.Open1.Enabled:=not s;
   paintform.Exit1.Enabled:=not s;
   paintform.Paste1.Enabled:=not s;
   //paintform.PopupMenu1.AutoPopup:=s;

   textform.File1.Enabled:=s;
   textform.Edit1.Enabled:=s;
   //textform.Open1.Enabled:=not s;
   textform.Exit1.Enabled:=not s;
   TextForm.PopupMenu1.AutoPopup:=s;
end;

procedure TDebugDlg.execute;
begin
   if StopRequest then exit;
   if pause then
     begin
       Caption:='PAUSE';
       Label2.Caption:=label0;
       OkBtn.Caption:='Ok';
       Cancel1.Visible:=false;
     end
   else
      begin
      Caption:='BREAK';
      Label2.Caption:=Label0;
      OkBtn.Caption:='Resume';
      Cancel1.Visible:=true;
      end;
   sr:=srNone;
   show;
   SwitchMenues(true);
   setFocus;
   //ActiveControl:=ListBox1;
   repeat
      sleep(10);
      Application.ProcessMessages;
   until sr<>srNone;
   if sr=srCancel then
      StopRequest:=true;
   close;
   SwitchMenues(false);
   ShowResult:=sr;
end;


procedure TDebugDlg.OKBtnClick(Sender: TObject);
begin
      sr:=srOk;
end;

procedure TDebugDlg.cancel1Click(Sender: TObject);
begin
    sr:=srCancel;
end;

procedure TDebugDlg.FormCreate(Sender: TObject);
begin
end;

procedure TDebugDlg.FormDestroy(Sender: TObject);
begin
end;

procedure TDebugDlg.FormResize(Sender: TObject);
begin
end;

var
  DebugDlgCriticalSection:TRtlCriticalSection;

procedure BreakPr(s:Ansistring);
begin
  wait(0.05);        //2018/5/5 Ver 2.0.2.1
  EnterCriticalSection(DebugDlgCriticalSection);
  DebugDLG.initBREAK(s);
  CtrlBreakHit:=true;
  while CtrlBreakHit do (TThread.CurrentThread).Yield;
  DebugDLG.initBREAK('Break');
  LeaveCriticalSection(DebugDlgCriticalSection);
end;

procedure PAUSE(s:Ansistring);
begin
  wait(0.05);        //2018/5/5 Ver 2.0.2.1
  EnterCriticalSection(DebugDlgCriticalSection);
  DebugDLG.initPAUSE(s);
  CtrlBreakHit:=true;
  while CtrlBreakHit do (TThread.CurrentThread).Yield;
  DebugDLG.initBREAK('Break');
  LeaveCriticalSection(DebugDlgCriticalSection);
end;

initialization
    InitCriticalSection(DebugDlgCriticalSection);

finalization
    DoneCriticalSection(DebugDlgCriticalSection);


end.
