unit graphlibd;

{$mode objfpc}{$H+}

(***************************************)
(* Copyright (C) 2013, SHIRAISHI Kazuo *)
(***************************************)

{********}
interface
{********}
uses arithmet,mathd,arrays,baslib,arraysd;

procedure MatPlotPoints(const x,y:TArray1D); overload;
procedure MatPlotPoints(const m:TArray2D);   overload;
procedure MatPlotLines(const x,y:TArray1D);  overload;
procedure MatPlotLines(const m:TArray2D);    overload;
procedure MatPlotArea(const x,y:TArray1D);   overload;
procedure MatPlotArea(const m:TArray2D);     overload;

procedure MatPlotPointsLimit(n:Number; const x,y:TArray1D);overload;
procedure MatPlotPointsLimit(n:Number; const m:TArray2D);  overload;
procedure MatPlotLinesLimit(n:Number; const x,y:TArray1D); overload;
procedure MatPlotLinesLimit(n:Number; const m:TArray2D);   overload;
procedure MatPlotAreaLimit(n:Number; const x,y:TArray1D);  overload;
procedure MatPlotAreaLimit(n:Number; const m:TArray2D);    overload;




procedure MatPlotCells(const p:TArray2D;  x1,y1,x2,y2:Number; insideofWhen:boolean);     overload;
procedure MatGraphCells(const p:TArray2D;  x1,y1,x2,y2:Number; insideofWhen:boolean);    overload;

{GET & LOCATE}
procedure PointAt(x0,y0:Number; LocateSt:boolean);                      overload;
procedure GetPoint(var x,y:Number; NoBeamOff:boolean; Locatest:boolean);overload;
procedure MousePoll(var x,y,l,r:Number);                          overload;
procedure MatGetPointVarilen(m:TArray2D; Locatest:boolean);       overload;
procedure MatGetPointVarilen(m1,m2:TArray1D; Locatest:boolean);   overload;
procedure MatGetPoint(m1,m2:TArray1D; Locatest:boolean);          overload;
procedure MatGetPoint(m:TArray2D; Locatest:boolean);              overload;


Procedure LocateChoice( var x:Number);overload;
Procedure LocateChoice(n:Number; var x:Number);overload;
Procedure LocateChoice(n,i0:Number; var x:Number);overload;
Procedure LocateChoice(const a:TArray1S; var x:Number);overload;


{ASK Statements}

function ASkWindow(var x1:Number; var x2:Number; var y1:Number; var y2:Number):integer; overload;
function AskViewPort(var x1:Number; var x2:Number; var y1:Number; var y2:Number):integer; overload;
function AskDeviceWindow(var x1:Number; var x2:Number; var y1:Number; var y2:Number):integer; overload;
function AskDeviceViewPort(var x1:Number; var x2:Number; var y1:Number; var y2:Number):integer; overload;

function  AskPixelSize( var var1,var2:Number):integer;      overload;
function  AskPixelSize(n1,n2,n3,n4:Number; var var1,var2:Number):integer;overload;
function  AskPixelSize(n1,n2,n3,n4:Number; var var1,var2:int64):integer;overload;
function  AskPixelValue(x,y:Number; var var1:Number):integer;        overload;
function  AskPixelArray(x,y:Number; a:TArray2D):integer;              overload;
function  AskPixelArray(x,y:Number; a:TArray2D; s:TStrVar):integer;   overload;

function getlinecolor(var x:Number):integer;  overload;
function getlinestyle(var x:Number):integer;  overload;
function getlinewidth(var x:Number):integer;  overload;
function getpointcolor(var x:Number):integer;  overload;
function getpointstyle(var x:Number):integer;  overload;
function getareacolor(var x:Number):integer;  overload;
function gettextcolor(var x:Number):integer;   overload;
function getmaxcolor(var x:Number):integer;   overload;
function getaxiscolor(var x:Number):integer;   overload;
function getMaxPointDevice(var x:Number):integer;   overload;
function getMaxMultiPointDevice(var x:Number):integer;  overload;
function getMaxChoiceDevice(var x:Number):integer;   overload;
function getMaxValueDevice(var x:Number):integer;   overload;
function getAreaStyleIndex(var x:Number):integer;   overload;
function getmaxlinestyle(var x:Number):integer;      overload;
function getmaxpointstyle(var x:Number):integer;     overload;

function ASkTextHeight(var x:Number):integer;       overload;
function AskTextAngle(var x:Number):integer;         overload;
function AskTextAngleRad(var x:Number):integer;     overload;
function AskDeviceSize(var x,y:Number; t:TStrVar):integer;   overload;
function AskBitmapSize(var x,y:Number):integer;              overload;
function AskTextWidth(const s:string; var width:Number):integer;  overload;

function AskColorMix(ColorIndex:Number; var red, green, blue:Number):integer;  overload;

procedure mlt(a:TArray2D);  overload;


implementation
uses graphsys, graphlib, affine, GraphQue;


{
function MakeDoubleArray(const a:array of Number):PNumberArray;
var
  p:PNumberArray;
  i:integer;
begin
  GetMem(p, sizeof(Double)*length(a)*2);
  for i:=low(a) to High(a) do
     begin
       p^[i*2]:=a[i].x;
       p^[i*2+1]:=a[i].y;
     end;
  result:=p;
end;
}



var ColorPointsCriticalSection: TRTLCriticalSection;



{
procedure PlotText(x,y:Number; const s:string);
begin
   graphlib.PlotText(ExtendedVal(x), ExtendedVal(y), s);
end;

procedure PlotTextUsing(x,y:Number; const form:string; a:array of const);
begin
   graphlib.PlotTextUsing(ExtendedVal(x), ExtendedVal(y), form, a);
end;

procedure GraphText(x,y:Number; const s:string);
begin
   graphlib.GraphText(ExtendedVal(x), ExtendedVal(y), s);
end;

procedure GraphTextUsing(x,y:Number; const form:string; a:array of const);
begin
   graphlib.GraphTextUsing(ExtendedVal(x), ExtendedVal(y), form, a);
end;

procedure PlotLabel(x,y:Number; const s:string);
begin
   graphlib.PlotLabel(ExtendedVal(x), ExtendedVal(y), s);
end;

procedure PlotLabelUsing(x,y:Number; const form:string; a:array of const);
begin
   graphlib.PlotLabelUsing(ExtendedVal(x), ExtendedVal(y), form, a);
end;

procedure GraphLabel(x,y:Number; const s:string);
begin
   graphlib.GraphLabel(ExtendedVal(x), ExtendedVal(y), s);
end;

procedure GraphLabelUsing(x,y:Number; const form:string; a:array of const);
begin
   graphlib.GraphLabelUsing(ExtendedVal(x), ExtendedVal(y), form, a);
end;

procedure PlotLetters(x,y:Number; const s:string);
begin
   graphlib.PlotLetters(ExtendedVal(x), ExtendedVal(y), s);
end;

procedure PlotLettersUsing(x,y:Number; const form:string; a:array of const);
begin
   graphlib.PlotLettersUsing(ExtendedVal(x), ExtendedVal(y), form, a);
end;
}






procedure MatPlotPoints(const x,y:TArray1D);overload;
var
  a,b:TArray1N;
begin
  a:=x.Array1N;
  b:=y.Array1N;
  try
     graphlib.MatPlotPoints(a,b);
  finally
    b.free;
    a.free;
  end;
end;




procedure MatPlotPoints(const m:TArray2D);overload;
var
  a:TArray2N;
begin
  a:=m.Array2N;
  try
      graphlib.MatPlotPoints(a);
  finally
     a.free;
  end;
end;

procedure MatPlotLines(const x,y:TArray1D);overload;
var
  a,b:TArray1N;
begin
  a:=x.Array1N;
  b:=y.Array1N;
  try
    graphlib.MatPlotLines(a,b);
  finally
    b.free;
    a.free;
  end;
end;

procedure MatPlotLines(const m:TArray2D);overload;
var
  a:TArray2N;
begin
  a:=m.Array2N;
  try
     graphlib.MatPlotLines(a);
  finally
     a.free;
  end;
end;


procedure MatPlotArea(const x,y:TArray1D);overload;
var
  a,b:TArray1N;
begin
  a:=x.Array1N;
  b:=y.Array1N;
  try
     graphlib.MatPlotArea(a,b);
  finally
    b.free;
    a.free;
  end;
end;




procedure MatPlotArea(const m:TArray2D);overload;
var
  a:TArray2N;
begin
  a:=m.Array2N;
  try
     graphlib.MatPlotArea(a);
  finally
     a.free;
  end;
end;

procedure MatPlotPointsLimit(n:Number; const x,y:TArray1D);overload;
var
  a,b:TArray1N;
begin
  a:=x.Array1N;
  b:=y.Array1N;
  try
     graphlib.MatPlotPointsLimit(ExtendedVal(n), a, b);
  finally
    b.free;
    a.free;
  end;
end;




procedure MatPlotPointsLimit(n:Number; const m:TArray2D);overload;
var
  a:TArray2N;
begin
  a:=m.Array2N;
  try
      graphlib.MatPlotPointsLimit(ExtendedVal(n), a);
  finally
     a.free;
  end;
end;

procedure MatPlotLinesLimit(n:Number; const x,y:TArray1D);overload;
var
  a,b:TArray1N;
begin
  a:=x.Array1N;
  b:=y.Array1N;
  try
    graphlib.MatPlotLinesLimit(ExtendedVal(n), a, b);
  finally
    b.free;
    a.free;
  end;
end;

procedure MatPlotLinesLimit(n:Number; const m:TArray2D);overload;
var
  a:TArray2N;
begin
  a:=m.Array2N;
  try
     graphlib.MatPlotLinesLimit(ExtendedVal(n), a);
  finally
     a.free;
  end;
end;



procedure MatPlotAreaLimit(n:Number; const x,y:TArray1D);overload;
var
  a,b:TArray1N;
begin
  a:=x.Array1N;
  b:=y.Array1N;
  try
     graphlib.MatPlotAreaLimit(ExtendedVal(n),a,b);
  finally
    b.free;
    a.free;
  end;
end;




procedure MatPlotAreaLimit(n:Number; const m:TArray2D);overload;
var
  a:TArray2N;
begin
  a:=m.Array2N;
  try
     graphlib.MatPlotAreaLimit(ExtendedVal(n),a);
  finally
     a.free;
  end;
end;




{MAT PLOT CELLS}

procedure MatPlotCells(const p:TArray2D;  x1,y1,x2,y2:Number; insideofWhen:boolean);
var
   a:TArray2N;
begin
   a:=p.Array2N;
   try
      graphlib.MatPlotCells(a, ExtendedVal(x1), ExtendedVal(y1), ExtendedVal(x2), ExtendedVal(y2),insideofwhen);
   finally
      a.free;
   end;
end;


procedure MatGraphCells(const p:TArray2D; x1,y1,x2,y2:Number; insideofWhen:boolean);
var
   a:TArray2N;
begin
   a:=p.Array2N;
   try
      graphlib.MatGraphCells(a, ExtendedVal(x1), ExtendedVal(y1), ExtendedVal(x2), ExtendedVal(y2),insideofwhen);
   finally
      a.free;
   end;
end;



{GET & LOCATE}
procedure PointAt(x0,y0:Number; LocateSt:boolean);
begin
    graphlib.PointAt(ExtendedVal(x0), ExtendedVal(y0), LocateSt);
end;

procedure GetPoint(var x,y:Number; NoBeamOff:boolean; Locatest:boolean);
var
   dx,dy:double;
begin
   graphlib.GetPoint(dx, dy, NoBeamOff, LocateSt);
   x:=dx;
   y:=dy;
end;


procedure MousePoll(var x,y,l,r:Number);                          overload;
var
   dx,dy,dl,dr:double;
begin
  Graphlib.MousePoll(dx, dy, dl, dr);
  x:=dx; y:=dy; l:=dl; r:=dr;
end;


procedure MatGetPointVarilen(m:TArray2D; Locatest:boolean); overload;
var
   a:TArray2N;
   i:integer;
begin
  with m do
      a:=TArray2N.create(Lbound(1), Ubound(1), Lbound(2), Ubound(2));
  try
     graphlib.MatGetPointVarilen(a, Locatest);
     m.size1:=a.size1;
     m.size2:=a.size2;
     with m do
       for i:=0 to size -1 do
          elements^[i]:=a.elements^[i];
  finally
     a.free;
  end;
end;

procedure MatGetPointVarilen(m1,m2:TArray1D; Locatest:boolean); overload;
var
   a1,a2:TArray1N;
   i:integer;
begin
  with m1 do
      a1:=TArray1N.create(Lbound, Ubound);
  with m2 do
      a2:=TArray1N.create(Lbound, Ubound);
  try
     graphlib.MatGetPointVarilen(a1,a2, Locatest);

     m1.size1:=a1.size1;
     with m1 do
       for i:=0 to size -1 do
          elements^[i]:=a1.elements^[i];

     m2.size1:=a2.size1;
     with m2 do
       for i:=0 to size -1 do
          elements^[i]:=a2.elements^[i];

  finally
     a2.free;
     a1.free;
  end;
end;

procedure MatGetPoint(m1,m2:TArray1D; Locatest:boolean); overload;
var
   a1,a2:TArray1N;
   i:integer;
begin
  with m1 do
      a1:=TArray1N.create(Lbound, Ubound);
  with m2 do
      a2:=TArray1N.create(Lbound, Ubound);
  try
     graphlib.MatGetPoint(a1,a2, Locatest);
     with m1 do
       for i:=0 to size -1 do
          elements^[i]:=a1.elements^[i];
     with m2 do
       for i:=0 to size -1 do
          elements^[i]:=a2.elements^[i];
  finally
     a2.free;
     a1.free;
  end;
end;

procedure MatGetPoint(m:TArray2D; Locatest:boolean);overload;
var
   a:TArray2N;
   i:integer;
begin
  with m do
      a:=TArray2N.create(Lbound(1), Ubound(1), Lbound(2), Ubound(2));
  try
     graphlib.MatGetPoint(a, Locatest);
     with m do
       for i:=0 to size -1 do
          elements^[i]:=a.elements^[i];
  finally
     a.free;
  end;
end;

Procedure LocateChoice( var x:Number);overload;
var
   dx:double;
begin
   graphlib.LocateChoice(dx);
   x:=dx
end;

Procedure LocateChoice( n:Number; var x:Number);overload;
var
   dx:double;
begin
   graphlib.LocateChoice(ExtendedVal(n), dx);
   x:=dx
end;

Procedure LocateChoice( n,i0:Number; var x:Number);overload;
var
   dx:double;
begin
   graphlib.LocateChoice(ExtendedVal(n), ExtendedVal(i0), dx);
   x:=dx
end;

Procedure LocateChoice(const a:TArray1S; var x:Number);overload;
var
   dx:double;
begin
   graphlib.LocateChoice(a, dx);
   x:=dx
end;



{ASK Statements}


function ASkWindow(var x1:Number; var x2:Number; var y1:Number; var y2:Number):integer; overload;
var
   dx1,dx2,dy1,dy2:double;
begin
   result:=graphlib.ASkWindow(dx1, dx2, dy1, dy2);
   x1:=dx1;
   x2:=dx2;
   y1:=dy1;
   y2:=dy2;
end;




function AskViewPort(var x1:Number; var x2:Number; var y1:Number; var y2:Number):integer; overload;
var
   dx1,dx2,dy1,dy2:double;
begin
   result:=graphlib.AskViewPort(dx1, dx2, dy1, dy2);
   x1:=dx1;
   x2:=dx2;
   y1:=dy1;
   y2:=dy2;
end;

function AskDeviceWindow(var x1:Number; var x2:Number; var y1:Number; var y2:Number):integer; overload;
var
   dx1,dx2,dy1,dy2:double;
begin
   result:=graphlib.AskDeviceWindow(dx1, dx2, dy1, dy2);
   x1:=dx1;
   x2:=dx2;
   y1:=dy1;
   y2:=dy2;
end;





function AskDeviceViewPort(var x1:Number; var x2:Number; var y1:Number; var y2:Number):integer; overload;
var
   dx1,dx2,dy1,dy2:double;
begin
   result:=graphlib.AskDeviceViewPort(dx1, dx2, dy1, dy2);
   x1:=dx1;
   x2:=dx2;
   y1:=dy1;
   y2:=dy2;
end;


function  AskPixelSize( var var1,var2:Number):integer;overload;
var
   d1,d2:double;
begin
   result:=graphlib.AskPixelSize(d1, d2);
   var1:=d1;
   var2:=d2;
end;

function  AskPixelSize(n1,n2,n3,n4:Number; var var1,var2:Number):integer;overload;
var
   d1,d2:double;
begin
   result:=graphlib.AskPixelSize(ExtendedVal(n1),ExtendedVal(n2),ExtendedVal(n3),ExtendedVal(n4),d1, d2);
   var1:=d1;
   var2:=d2;
end;

function  AskPixelSize(n1,n2,n3,n4:Number; var var1,var2:int64):integer;overload;
begin
   result:=graphlib.AskPixelSize(ExtendedVal(n1),ExtendedVal(n2),ExtendedVal(n3),ExtendedVal(n4),var1, var2);
end;


function  AskPixelValue(x,y:Number; var var1:Number):integer;
var
   d1:double;
begin
   result:=graphlib.AskPixelValue(ExtendedVal(x),ExtendedVal(y),d1);
   var1:=d1;
end;


function  AskPixelArray(x,y:Number; a:TArray2D):integer; overload;
var
   n:TArray2N;
   i:integer;
begin
  with a do
      n:=TArray2N.create(Lbound(1), Ubound(1), Lbound(2), Ubound(2));
  try
     result:=graphlib.AskPixelArray(ExtendedVal(x), ExtendedVal(y), n);
     with a do
       for i:=0 to size -1 do
          elements^[i]:=n.elements^[i];
  finally
     n.free;
  end;
end;

function  AskPixelArray(x,y:Number; a:TArray2D; s:TStrVar):integer; overload;
var
   n:TArray2N;
   i:integer;
begin
  with a do
      n:=TArray2N.create(Lbound(1), Ubound(1), Lbound(2), Ubound(2));
  try
     result:=graphlib.AskPixelArray(ExtendedVal(x), ExtendedVal(y), n, s);
     with a do
       for i:=0 to size -1 do
          elements^[i]:=n.elements^[i];
  finally
     n.free;
  end;
end;


function getlinecolor(var x:Number):integer;
var
   dx:double;
begin
  result:=graphlib.GetLineColor(dx);
  x:=dx;
end;

function getlinestyle(var x:Number):integer;
var
   dx:double;
begin
  result:=graphlib.GetLineStyle(dx);
  x:=dx;
end;

function getlinewidth(var x:Number):integer;
var
   dx:double;
begin
  result:=graphlib.GetLineWidth(dx);
  x:=dx;
end;

function getpointcolor(var x:Number):integer;
var
   dx:double;
begin
  result:=graphlib.GetPointColor(dx);
  x:=dx;
end;

function getpointstyle(var x:Number):integer;
var
   dx:double;
begin
  result:=graphlib.GetPointStyle(dx);
  x:=dx;
end;

function getareacolor(var x:Number):integer;
var
   dx:double;
begin
  result:=graphlib.GetAreaColor(dx);
  x:=dx;
end;

function gettextcolor(var x:Number):integer;
var
   dx:double;
begin
  result:=graphlib.GetTextColor(dx);
  x:=dx;
end;

function getmaxcolor(var x:Number):integer;
var
   dx:double;
begin
  result:=graphlib.GetMaxColor(dx);
  x:=dx;
end;

function getaxiscolor(var x:Number):integer;
var
   dx:double;
begin
  result:=graphlib.GetAxisColor(dx);
  x:=dx;
end;

function getMaxPointDevice(var x:Number):integer;
var
   dx:double;
begin
  result:=graphlib.GetMaxPointDevice(dx);
  x:=dx;
end;

function getMaxMultiPointDevice(var x:Number):integer;
var
   dx:double;
begin
  result:=graphlib.GetMaxMultiPointDevice(dx);
  x:=dx;
end;
function getMaxChoiceDevice(var x:Number):integer;
var
   dx:double;
begin
  result:=graphlib.GetMaxChoiceDevice(dx);
  x:=dx;
end;

function getMaxValueDevice(var x:Number):integer;
var
   dx:double;
begin
  result:=graphlib.GetMaxValueDevice(dx);
  x:=dx;
end;

function getAreaStyleIndex(var x:Number):integer;
var
   dx:double;
begin
  result:=graphlib.GetAreaStyleIndex(dx);
  x:=dx;
end;

function getmaxlinestyle(var x:Number):integer;
var
   dx:double;
begin
  result:=graphlib.getmaxlinestyle(dx);
  x:=dx;
end;

function getmaxpointstyle(var x:Number):integer;
var
   dx:double;
begin
  result:=graphlib.getmaxpointstyle(dx);
  x:=dx;
end;


function ASkTextHeight(var x:Number):integer;
var
   dx:double;
begin
  result:=graphlib.ASkTextHeight(dx);
  x:=dx;
end;

function AskTextAngle(var x:Number):integer;
var
   dx:double;
begin
  result:=graphlib.ASkTextAngle(dx);
  x:=dx;
end;

function AskTextAngleRad(var x:Number):integer;
var
   dx:double;
begin
  result:=graphlib.ASkTextAngleRad(dx);
  x:=dx;
end;

function AskDeviceSize(var x,y:Number; t:TStrVar):integer;
var
   dx,dy:double;
begin
   result:=graphlib.AskDeviceSize(dx, dy, t);
   x:=dx; y:=dy
end;

function AskBitmapSize(var x,y:Number):integer;
var
   dx,dy:double;
begin
   result:=graphlib.AskBitmapSize(dx, dy);
   x:=dx; y:=dy
end;

function AskTextWidth(const s:string; var width:Number):integer;
var
   dw:double;
begin
  result:=graphlib.AskTextWidth(s, dw);
  width:=dw
end;

function AskColorMix(ColorIndex:Number; var red,green,blue:Number):integer;
var
   dr,dg,db:double;
begin
   result:=graphlib.AskColorMix(ExtendedVal(ColorIndex), dr,dg,db);
   red:=dr; green:=dg; blue:=db;
end;

type
  Tmlt=class(TGraphCommand)
    a:TArray2D;
    constructor create(a0:TArray2D);
    procedure execute;override;
    destructor destroy;override;
  end;
constructor Tmlt.create(a0:TArray2D);
begin
  inherited create;
  a:=a0.NewCopy;
end;
procedure Tmlt.execute;
begin
   currenttransform.mlt(a);
end;
destructor TMlt.destroy;
begin
  a.free;
  inherited destroy;
end;

procedure mlt(a:TArray2D);
begin
  addQueue(Tmlt.create(a))
end;







end.

