! コッホ曲線
! 底辺ABの長さが3で高さがsqr(3)/2の二等辺三角形CABで，頂点Aを不動点として，点Bを点Cに移し，点Cを線分AB上の点に移すような相似変換をf1，
! 頂点Bを不動点として，点Aを点Cに移し，点Cを線分BA上の点に移すような相似変換をf2とするとき，
! f1,f2に対して，f1(D)∪f2(D)=D となる自己相似図形Dをコッホ曲線といいます（曲線という名前がついていますが，定義自体からは曲線かどうかわかりません。）
! このプログラムは，上の定義をほとんどそのままに実行してコッホ曲線の近似解を描きます。
! このプログラムでは，３頂点の座標をA(0,0)，B(3,0)，C(3/2,SQR(3)/2) と仮定します。
! 縮小写像f1,f2の倍率rを280行で計算しています。線分ACの長さを線分ABの長さで割って求めています。
! 再帰呼び出しの度に絵Kochの引数sにrを乗じていきます。
! 最初sの値は1です（320行）。
! sの値がビットマップの大きさに比べて無視できる大きさになったとき，1点を描きます（220行）。
! したがって，描画領域のドット数を増やして実行する場合には，210行の定数を大きくして実行する必要があります。
! 参考文献 「カオスとフラクタル入門」山口昌哉 （放送大学印刷教材）ISBN4-595-56791-X
PICTURE Koch(n)
   IF n=0 THEN 
      PLOT AREA : 0,0; 3,0; 3/2, SQR(3)/2; 0,0
   ELSE
      DRAW Koch(n-1) WITH SCALE(1,-1)*ROTATE(alfa)*SCALE(r) 
      DRAW Koch(n-1) WITH SHIFT(-3,0)*SCALE(1,-1)*ROTATE(-alfa)*SCALE(r)*SHIFT(3,0)
   END IF
END PICTURE
LET r=SQR((3/2)^2+(SQR(3)/2)^2) / 3
LET alfa=ANGLE(3/2,SQR(3)/2)
SET WINDOW 0,3,0,3
SET POINT STYLE 1
FOR n=1 TO 12
   CLEAR
   DRAW Koch(n)
   WAIT DELAY 1
NEXT n
END
