unit setupop;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls;

type

  { TSetUpOptionsDlg }

  TSetUpOptionsDlg = class(TForm)
    CfAVX: TCheckBox;
    Cfavx2: TCheckBox;
    AdditionalOptions: TEdit;
    GroupBox2: TGroupBox;
    Label3: TLabel;
    Label5: TLabel;
    ReportExtype: TCheckBox;
    OmitIndexCheck: TCheckBox;
    ExpertMode: TCheckBox;
    GroupBox4: TGroupBox;
    LabelAdditinal: TLabel;
    NewFileDialog: TCheckBox;
    OkBtn: TButton;
    CancelBtn: TButton;
    OoFastMath: TCheckBox;
    Debug: TGroupBox;
    OptimizeLevel: TRadioGroup;
    RGDrawTimeInterval: TRadioGroup;
    RGDrawTimeIntervalAhead: TRadioGroup;
    SmartLink: TCheckBox;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    OptimInteger: TCheckBox;
    OptimDouble: TCheckBox;
    Panel1: TPanel;
    TrackBar1: TTrackBar;
    TrackBar2: TTrackBar;
    UseVirtualStack: TCheckBox;
    procedure ExpertModeChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure TrackBar2Change(Sender: TObject);
    procedure UseVirtualStackChange(Sender: TObject);
  private
    procedure rearrange;
  public
    procedure execute;
  end; 

var
  SetUpOptionsDlg: TSetUpOptionsDlg;

implementation
{ TSetUpOptionsDlg }
uses base0,SetPath,arithmet;
{$R *.lfm}

const
      d1=16;
  const1={$IFDEF Windows} 8{$ELSE} 4{$ENDIF};
  const2={$IFDEF Windows}32{$ELSE}16{$ENDIF};


procedure TSetUpOptionsDlg.execute;
var
  s:boolean;
begin
    UseVirtualStack.Checked := Not(UseHeapForArrays32 and not TargetCPU64 or UseHeapForArrays64 and TargetCpu64);
    OptimDouble.checked  := OptimizeDouble;
    RGDrawTimeInterval.ItemIndex:=DrawTimeIntervalIndex;
    RGDrawTimeIntervalAhead.ItemIndex:=DrawTimeIntervalAheadIndex;
    SmartLink.Checked:=base0.UseSmartLink;
    GroupBox2.Visible:=UseVirtualStack.checked;
    OptimInteger.checked:=OptimizeInteger;
    OmitIndexCheck.checked:=base0.OmitIndexCheck;
    ReportExtype.checked:=initialUseEXTYPE;
    if TargetCPU64 then
      begin
         TrackBar1.Position:=  (SystemStackSize64 div const1) div (1048576 div d1) ;
         TrackBar2.Position:= (VirtualStackSize64 div const2) div  1048576 ;
         Optimizelevel.ItemIndex:=base0.OptimizeLevel64;
         OoFastMath.Checked := base0.OoFastMath64;
         NewFileDialog.Checked := not base0.OldDialog64;
         s:=base0.availAVX;
         CfAVX.Checked := s and base0.CfAVX;
         CfAVX.Enabled:=s;
         CfAVX.Visible:=s;
         s:=base0.availAVX2;
         CfAVX2.Checked := s and base0.CfAVX2;
         CfAVX2.Enabled:=s;
         CfAVX2.Visible:=s;
         AdditionalOptions.text:=base0.AdditionalOptions64;
      end
    else
      begin
       TrackBar1.Position:= SystemStackSize32  div (1048576 div d1) ;
       TrackBar2.Position:= VirtualStackSize32 div  1048576 ;
       Optimizelevel.ItemIndex:=base0.OptimizeLevel32;
       OoFastMath.Checked := base0.OoFastMath32;
       NewFileDialog.Checked := not base0.OldDialog32;
       CfAVX.Visible:=false;
       CfAVX2.Visible:=false;
       AdditionalOptions.text:=base0.AdditionalOptions32;
     end;

    if showModal =mrOk then
      begin
          if TargetCPU64 then
            begin
             SystemStackSize64:= Int64(TrackBar1.Position)*const1 *(1048576 div d1);
             VirtualStackSize64:=Int64(Trackbar2.Position)*const2 * 1048576;
             base0.OptimizeLevel64:=OptimizeLevel.itemindex;
             base0.OoFastMath64:=OoFastMath.Checked;
             base0.OldDialog64:=not NewFileDialog.Checked;
             base0.CfAVX:=CfAVX.Checked;
             base0.CfAVX2:=CfAVX2.Checked;
             base0.AdditionalOptions64 := AdditionalOptions.text;
          end
          else
            begin
              SystemStackSize32:= TrackBar1.Position* (1048576 div d1);
              VirtualStackSize32:=Trackbar2.Position*  1048576;
              base0.OptimizeLevel32:=OptimizeLevel.itemindex;
              base0.OoFastMath32:=OoFastMath.Checked;
              base0.OldDialog32:=not NewFileDialog.Checked;
              base0.AdditionalOptions32 := AdditionalOptions.text;
           end;
           initialUseEXTYPE :=ReportExtype.checked;
           base0.OmitIndexCheck := OmitIndexCheck.checked;
           base0.UseSmartLink := SmartLink.Checked;
           OptimizeInteger := OptimInteger.checked;
           OptimizeDouble  := OptimDouble.checked;
           DrawTimeIntervalIndex:=RGDrawTimeInterval.ItemIndex;
           DrawTimeIntervalAheadIndex:=RGDrawTimeIntervalAhead.ItemIndex;
           if TargetCPU64 and (UseHeapForArrays64=UseVirtualStack.Checked)
           or not TargetCPU64 and (UseHeapForArrays32=UseVirtualStack.Checked) then
             begin
               if TargetCPU64 then
                 UseHeapForArrays64:=not UseVirtualStack.Checked
               else
                 UseHeapForArrays32:=not UseVirtualStack.Checked;
               SysUtils.DeleteFile(ExtractFileDir(application.exename)+'\output\vstack.ppu');
               SysUtils.DeleteFile(ExtractFileDir(application.exename)+'\output\vstack.o');
               SysUtils.DeleteFile(ExtractFileDir(application.exename)+'\output\arrays.ppu');
               SysUtils.DeleteFile(ExtractFileDir(application.exename)+'\output\arrays.o');
             end;

      end;
end;

procedure TSetUpOptionsDlg.FormShow(Sender: TObject);
begin
   TrackBar1Change(Sender);
   TrackBar2Change(Sender);
end;




procedure TSetUpOptionsDlg.TrackBar1Change(Sender: TObject);
var
   n:number;
begin
   if TargetCPU64 then
     Label1.caption:=IntToStr(TrackBar1.position  * const1 div d1)
   else
     begin
       initdecimal(n, TrackBar1.position / d1);
       Label1.caption:=DStr(n);
       ReArrange;
     end;
end;

procedure TSetUpOptionsDlg.TrackBar2Change(Sender: TObject);
begin
      if TargetCPU64 then
      Label3.caption:=IntToStr(TrackBar2.position * const2)
   else
     begin
       ReArrange;
       Label3.caption:=IntToStr(TrackBar2.position);
     end;
end;

procedure TSetUpOptionsDlg.UseVirtualStackChange(Sender: TObject);
begin
      GroupBox2.Visible:= UseVirtualStack.checked;
end;





procedure TSetUpOptionsDlg.ReArrange;
var
  mem1,mem2:cardinal;
begin
  if TargetCPU64 then exit;
  mem1:= TrackBar1.position  *(1048576 div d1);
    mem2:= TrackBar2.position *  1048576;
  if mem1+mem2>1920 * 1048576  then
    begin
       mem2:=1920*1048576-mem1;
       TrackBar2.position:=mem2 div 1048576 ;
    end;
end;



procedure TSetUpOptionsDlg.FormCreate(Sender: TObject);
var
  i:integer;
begin
  OptimInteger.Enabled:=false;
  OmitIndexCheck.Enabled:=false;
  for i:=0 to 4 do
     RGDrawTimeInterval.Items.Strings[i]:=DrawTimeIntervalLiteral[i]+'ms';
end;

procedure TSetUpOptionsDlg.ExpertModeChange(Sender: TObject);
begin
    if ExpertMode.Checked then
      begin
        OptimInteger.Enabled:=true;
        OmitIndexCheck.Enabled:=true;
        RGDrawTimeInterval.Enabled:=true;
        RGDrawTimeIntervalAhead.Enabled:=true;
      end
    else
      begin
         OptimInteger.Checked:=false;
         OptimInteger.Enabled:=false;
         OmitIndexCheck.Checked:=false;
         OmitIndexCheck.Enabled:=false;
         RGDrawTimeInterval.ItemIndex:=0;
         RGDrawTimeInterval.Enabled:=false;
         RGDrawTimeIntervalAhead.ItemIndex:=0;
         RGDrawTimeIntervalAhead.Enabled:=false;

     end;
end;





initialization

end.

