/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.lr;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.morilib.automata.lr.GrammarSymbol;
import net.morilib.automata.lr.LRUtils;
import net.morilib.automata.lr.Nonterminal;

public class ContextFreeRule {
    private Nonterminal left;
    private List<GrammarSymbol> derived;

    public ContextFreeRule(Nonterminal left, GrammarSymbol ... derived) {
        if (derived == null) {
            throw new NullPointerException("Argument 'derived' must not be null");
        }
        this.left = left;
        this.derived = Arrays.asList(derived);
    }

    public Nonterminal getLeftSymbol() {
        return this.left;
    }

    public List<GrammarSymbol> getDerivedSymbols() {
        return Collections.unmodifiableList(this.derived);
    }

    public int getDerivedSymbolLength() {
        return this.derived.size();
    }

    public GrammarSymbol getDerivedSymbol(int no) {
        return this.derived.get(no);
    }

    public boolean isEpsilon() {
        return this.derived.isEmpty();
    }

    public boolean equals(Object o) {
        if (o instanceof ContextFreeRule) {
            ContextFreeRule rule = (ContextFreeRule)o;
            return LRUtils.equals(this.left, rule.left) && LRUtils.equals(this.derived, rule.derived);
        }
        return false;
    }

    public int hashCode() {
        int r = 17;
        r += 37 * (LRUtils.hashCode(this.left) + r);
        r += 37 * (LRUtils.hashCode(this.derived) + r);
        return r;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(LRUtils.toString(this.left));
        buf.append(" -> ");
        int i = 0;
        while (i < this.derived.size()) {
            buf.append(this.derived.get(i));
            buf.append(" ");
            ++i;
        }
        return buf.toString();
    }
}

