/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.lr;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.morilib.automata.lr.ContextFreeGrammar;
import net.morilib.automata.lr.ContextFreeRule;
import net.morilib.automata.lr.GrammarSymbol;
import net.morilib.automata.lr.LR0Items;
import net.morilib.automata.lr.LRUtils;
import net.morilib.automata.lr.LinkedListStack;
import net.morilib.automata.lr.Nonterminal;
import net.morilib.automata.lr.ObjectArray;
import net.morilib.automata.lr.StateGraph;
import net.morilib.automata.lr.Terminal;

public final class LALR1Items {
    private ContextFreeGrammar grammar;
    private StateGraph<Integer, GrammarSymbol> goTo = new StateGraph();
    private List<Set<Item>> itemsArray;
    private int initialItems;

    LALR1Items(ContextFreeGrammar g) {
        this.grammar = g;
    }

    public static LALR1Items newLALR(ContextFreeGrammar g) {
        LR0Items lr0 = LR0Items.build(g);
        LALR1Items res = new LALR1Items(g);
        res.initializeItems(lr0);
        boolean dirt = res.spontaneousLookahead();
        do {
            dirt = res.propagateLookahead();
        } while (dirt = res.spontaneousLookahead() | dirt);
        return res;
    }

    boolean addLookahead(Set<Item> items, Set<Terminal> lookaheads) {
        boolean res = false;
        for (Item i : items) {
            res = i.lookahead.addAll(lookaheads) | res;
        }
        return res;
    }

    private boolean propagateLookaheadItem(int i, Item j, Item k, boolean dirt) {
        boolean res = dirt;
        if (!k.isReduceState()) {
            GrammarSymbol xx = k.getDirectedSymbol();
            Set<Item> gg = this.findGoTo(this.goTo, i, xx);
            if (gg != null && k.lookahead.contains(ContextFreeGrammar.DMY)) {
                for (Item l : gg) {
                    if (!l.equalsWithoutLookahead(k.shift())) continue;
                    res = l.lookahead.addAll(j.lookahead) | res;
                }
            }
        } else if (k.isEpsilon()) {
            Item kk = this.findItem(this.goTo, i, k);
            res = kk.lookahead.addAll(j.lookahead) | res;
        }
        return res;
    }

    boolean propagateLookahead() {
        boolean res = false;
        Set<Integer> items = this.goTo.getAllNodes();
        for (Integer i : items) {
            for (Item j : this.itemsArray.get(i)) {
                if (!this.isKernel(j)) continue;
                Item jx = new Item(j.getRule(), new HashSet<Terminal>(), j.itemId);
                jx.lookahead.add(ContextFreeGrammar.DMY);
                Set<Item> cl = this.computeItemClosure(Collections.singleton(jx));
                for (Item k : cl) {
                    res = this.propagateLookaheadItem(i, j, k, res);
                }
            }
        }
        return res;
    }

    private boolean spontaneousLookaheadItem(int i, Item j, Item k, boolean dirt) {
        boolean res = dirt;
        if (!k.isReduceState()) {
            GrammarSymbol xx = k.getDirectedSymbol();
            Set<Item> gg = this.findGoTo(this.goTo, i, xx);
            if (gg != null) {
                for (Item l : gg) {
                    if (!l.equalsWithoutLookahead(k.shift())) continue;
                    HashSet lhb = new HashSet(k.lookahead);
                    lhb.remove(ContextFreeGrammar.DMY);
                    res = l.lookahead.addAll(lhb) | res;
                }
            }
        } else if (k.isEpsilon()) {
            Item kk = this.findItem(this.goTo, i, k);
            HashSet lhb = new HashSet(k.lookahead);
            lhb.remove(ContextFreeGrammar.DMY);
            res = kk.lookahead.addAll(lhb) | res;
        }
        return res;
    }

    boolean spontaneousLookahead() {
        boolean res = false;
        Set<Integer> items = this.goTo.getAllNodes();
        for (Integer i : items) {
            for (Item j : this.itemsArray.get(i)) {
                if (!this.isKernel(j)) continue;
                Item jx = new Item(j.getRule(), new HashSet<Terminal>(), j.itemId);
                jx.lookahead.add(ContextFreeGrammar.DMY);
                Set<Item> cl = this.computeItemClosure(Collections.singleton(jx));
                for (Item k : cl) {
                    res = this.spontaneousLookaheadItem(i, j, k, res);
                }
            }
        }
        return res;
    }

    void initializeItems(LR0Items lr0) {
        Set<Set<LR0Items.Item>> lr0g = lr0.getGoToMap().getAllNodes();
        StateGraph<Integer, GrammarSymbol> mp = new StateGraph<Integer, GrammarSymbol>();
        HashMap<Set<LR0Items.Item>, Integer> taio = new HashMap<Set<LR0Items.Item>, Integer>();
        this.itemsArray = new ObjectArray<Set<Item>>(lr0.getStateSize());
        Iterator<Set<LR0Items.Item>> itr = lr0g.iterator();
        int ci = 0;
        while (itr.hasNext()) {
            Set<LR0Items.Item> s1 = itr.next();
            HashSet<Item> r1 = new HashSet<Item>();
            for (LR0Items.Item j : s1) {
                Item ni = new Item(j);
                if (lr0.isInitialState(s1)) {
                    ni.lookahead.add(ContextFreeGrammar.ENDMARKER);
                }
                r1.add(ni);
            }
            this.itemsArray.set(ci, r1);
            mp.addNode(ci);
            taio.put(s1, ci);
            ++ci;
        }
        for (Set<LR0Items.Item> s0 : lr0g) {
            Map<GrammarSymbol, Set<LR0Items.Item>> p0 = lr0.getGoToMap().getEdgeMap(s0);
            Integer s1 = (Integer)taio.get(s0);
            for (GrammarSymbol j : p0.keySet()) {
                mp.addTrans(s1, j, (Integer)taio.get(p0.get(j)));
            }
        }
        this.goTo = mp;
        this.initialItems = (Integer)taio.get(lr0.getInitialState());
    }

    Item findSameRule(ContextFreeRule r, Set<Item> r2) {
        for (Item k : r2) {
            if (!r.equals(k.getRule())) continue;
            return k;
        }
        return null;
    }

    Set<Item> computeItemClosure(Set<Item> items) {
        LinkedListStack<Item> stk = new LinkedListStack<Item>(items);
        HashSet<Item> res = new HashSet<Item>(items);
        do {
            Item itm = (Item)stk.pop();
            List<GrammarSymbol> beta = itm.getRightOfDirectedSymbol();
            GrammarSymbol bb = null;
            if (!beta.isEmpty()) {
                bb = beta.remove(0);
            }
            if (itm.isReduceState() || !(bb instanceof Nonterminal)) continue;
            Set<ContextFreeRule> rules = this.grammar.findRules((Nonterminal)bb);
            for (ContextFreeRule r : rules) {
                HashSet<Terminal> bs = new HashSet<Terminal>();
                for (Terminal kn : itm.lookahead) {
                    LinkedList<GrammarSymbol> beta2 = new LinkedList<GrammarSymbol>(beta);
                    beta2.add(kn);
                    ContextFreeGrammar.First f = this.grammar.firstAll(beta2);
                    bs.addAll(f.getNotNullSymbols());
                }
                Item itm2 = this.findSameRule(r, res);
                if (itm2 == null) {
                    itm2 = new Item(r);
                } else {
                    res.remove(itm2);
                }
                if (itm2.lookahead.addAll(bs)) {
                    stk.push(itm2);
                }
                res.add(itm2);
            }
        } while (!stk.isEmpty());
        return res;
    }

    StateGraph<Integer, GrammarSymbol> getGoTo() {
        return this.goTo;
    }

    String toStringGoTo() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.itemsArray.size()) {
            buf.append(i).append(":").append(this.itemsArray.get(i));
            buf.append("\n");
            ++i;
        }
        return buf.toString();
    }

    Set<Item> findGoTo(StateGraph<Integer, GrammarSymbol> aGoTo, int state, GrammarSymbol symbol) {
        return this.itemsArray.get(aGoTo.get(state, symbol));
    }

    Item findItem(StateGraph<Integer, GrammarSymbol> aGoTo, Integer state, Item itm) {
        for (Item i : this.itemsArray.get(state)) {
            if (!i.equalsWithoutLookahead(itm)) continue;
            return i;
        }
        return null;
    }

    public int goToID(int stateid, GrammarSymbol symbol) {
        if (stateid < 0 || stateid >= this.itemsArray.size()) {
            throw new IndexOutOfBoundsException("" + stateid);
        }
        return this.goTo.get(stateid, symbol);
    }

    public int getInitialStateID() {
        return this.initialItems;
    }

    public Set<Item> getItems(int stateid) {
        if (stateid < 0 || stateid >= this.itemsArray.size()) {
            throw new IndexOutOfBoundsException("" + stateid);
        }
        return Collections.unmodifiableSet(this.itemsArray.get(stateid));
    }

    public int getSizeOfStates() {
        return this.itemsArray.size();
    }

    public ContextFreeGrammar getGrammar() {
        return this.grammar;
    }

    public boolean isKernel(Item item) {
        return item.itemId > 0 || this.grammar.isAugmentSymbol(item.rule.getLeftSymbol());
    }

    public static final class Item {
        private ContextFreeRule rule;
        private Set<Terminal> lookahead;
        private int itemId = 0;

        Item(ContextFreeRule rule) {
            this(rule, new HashSet<Terminal>());
        }

        Item(ContextFreeRule rule, Set<Terminal> lookahead) {
            if (rule == null) {
                throw new NullPointerException();
            }
            this.rule = rule;
            this.lookahead = lookahead;
        }

        Item(ContextFreeRule rule, Set<Terminal> lookahead, int itemId) {
            this(rule, lookahead);
            this.itemId = itemId;
        }

        Item(Item item) {
            this(item.rule, new HashSet<Terminal>(item.lookahead), item.itemId);
        }

        Item(LR0Items.Item item0) {
            this(item0.getRule(), new HashSet<Terminal>(), item0.getItemId());
        }

        List<GrammarSymbol> getRightOfDirectedSymbol() {
            List<GrammarSymbol> lst = this.rule.getDerivedSymbols();
            return new LinkedList<GrammarSymbol>(lst.subList(this.itemId, lst.size()));
        }

        int getItemId() {
            return this.itemId;
        }

        public GrammarSymbol getDirectedSymbol() {
            return this.rule.getDerivedSymbol(this.itemId);
        }

        public boolean isReduceState() {
            return this.itemId == this.rule.getDerivedSymbolLength();
        }

        public Set<Terminal> getLookaheadSet() {
            return Collections.unmodifiableSet(this.lookahead);
        }

        public Item shift() {
            if (!this.isReduceState()) {
                return new Item(this.rule, this.lookahead, this.itemId + 1);
            }
            throw new IllegalStateException();
        }

        public ContextFreeRule getRule() {
            return this.rule;
        }

        public boolean isEpsilon() {
            return this.rule.isEpsilon();
        }

        public boolean equals(Object o) {
            if (o instanceof Item) {
                Item item = (Item)o;
                return LRUtils.equals(this.rule, item.rule) && LRUtils.equals(this.lookahead, item.lookahead) && this.itemId == item.itemId;
            }
            return false;
        }

        public boolean equalsWithoutLookahead(Object o) {
            if (o instanceof Item) {
                Item item = (Item)o;
                return LRUtils.equals(this.rule, item.rule) && this.itemId == item.itemId;
            }
            return false;
        }

        public int hashCode() {
            int r = 17;
            r += 37 * LRUtils.hashCode(this.rule) + r;
            r += 37 * LRUtils.hashCode(this.itemId) + r;
            r += 37 * LRUtils.hashCode(this.lookahead) + r;
            return r;
        }

        public String toString() {
            List<GrammarSymbol> derived = this.rule.getDerivedSymbols();
            StringBuffer buf = new StringBuffer();
            buf.append(LRUtils.toString(this.rule.getLeftSymbol()));
            buf.append(" -> ");
            int i = 0;
            while (i < derived.size()) {
                if (i == this.itemId) {
                    buf.append("*");
                }
                buf.append(derived.get(i));
                buf.append(" ");
                ++i;
            }
            buf.append(", ").append(this.lookahead);
            return buf.toString();
        }
    }
}

