/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.deculture.cmd;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.deculture.cmd.DecultureOptions;
import net.morilib.deculture.translate.DecultureSyntaxException;
import net.morilib.deculture.translate.DecultureTranslator;
import net.morilib.deculture.translate.LRObject;

public class Deculture {
    public static final String VERSION = "0.0.0";
    private static final Pattern FP = Pattern.compile("(/?([^/]*/)*)([^/\\.]+)(\\.de?c?u?l?t?u?r?e?)?");
    private static DecultureOptions options;

    private static int parseoption(String[] args) {
        options = new DecultureOptions();
        return 0;
    }

    public static void main(String[] args) {
        Matcher m;
        PrintStream ot = null;
        InputStream in = null;
        int a = Deculture.parseoption(args);
        if (args.length <= a || !(m = FP.matcher(args[a])).matches()) {
            options.usage();
            System.exit(1);
        } else {
            String s;
            Deculture.options.filename = args[a];
            Deculture.options.outputFilename = s = m.group(3);
            char[] b = s.toCharArray();
            b[0] = Character.toUpperCase(b[0]);
            try {
                try {
                    in = new FileInputStream(args[a]);
                    DecultureTranslator l = LRObject.parse(in);
                    if (l == null) {
                        options.print("unknownlanguage", new Object[0]);
                        System.exit(2);
                    }
                    s = String.valueOf(new String(b)) + l.getExtension();
                    ot = new PrintStream(new FileOutputStream(s));
                    l.translate(ot, options);
                    int z = l.howManyShiftReduceConflicts();
                    if (z > 0) {
                        options.print("shiftreduce", z, options.get("conflictplural"));
                    }
                    if ((z = l.howManyReduceReduceConflicts()) > 0) {
                        options.print("reducereduce", z, options.get("conflictplural"));
                    }
                    System.exit(0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(4);
                    try {
                        if (in != null) {
                            in.close();
                        }
                        if (ot != null) {
                            ot.close();
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                        System.exit(2);
                    }
                }
                catch (DecultureSyntaxException e) {
                    options.perror(e.getMessage(), e.getLineNumber());
                    System.exit(2);
                    try {
                        if (in != null) {
                            in.close();
                        }
                        if (ot != null) {
                            ot.close();
                        }
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                        System.exit(2);
                    }
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (ot != null) {
                        ot.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(2);
                }
            }
        }
    }
}

