/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.deculture.translate;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.morilib.automata.lr.ContextFreeGrammar;
import net.morilib.automata.lr.ContextFreeRule;
import net.morilib.automata.lr.LR1Table;
import net.morilib.automata.lr.LRConflict;
import net.morilib.deculture.cmd.DecultureOptions;
import net.morilib.deculture.sh.DecultureFileSystem;
import net.morilib.deculture.translate.DecultureTranslator;
import net.morilib.deculture.translate.LRObject;
import net.morilib.sh.DefaultShRuntime;
import net.morilib.sh.ShBuiltInCommands;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFacade;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShRootEnvironment;
import net.morilib.sh.ShRuntime;
import net.morilib.sh.ShSyntaxException;
import net.morilib.sh.misc.XtraceStream;

public abstract class AbstractDecultureTranslator
implements DecultureTranslator {
    protected static final String __ERROR = "";
    protected LRObject lr;
    protected Map<ContextFreeRule, Object> actionMap;
    protected Map<Object, Integer> nonterminalMap = new HashMap<Object, Integer>();
    private int nonterminalNumber = 0;

    AbstractDecultureTranslator(LRObject lr) {
        this.lr = lr;
        this.actionMap = new HashMap<ContextFreeRule, Object>(lr.getActionMap());
    }

    protected int getNonterminalNumber(Object o) {
        if (this.nonterminalMap.containsKey(o)) {
            return this.nonterminalMap.get(o);
        }
        this.nonterminalMap.put(o, this.nonterminalNumber);
        return this.nonterminalNumber++;
    }

    public String getDefinition() {
        return this.lr.getDefinition().getDefinition();
    }

    public ContextFreeGrammar getGrammar() {
        return this.lr.getGrammar();
    }

    public LR1Table getTable() {
        return this.lr.getTable();
    }

    public Collection<LRConflict> getConflicts() {
        return this.lr.getTable().getConflicts();
    }

    public Object getAction(ContextFreeRule rule) {
        return this.actionMap.get(rule);
    }

    public void setAction(ContextFreeRule rule, Object action) {
        this.actionMap.put(rule, action);
    }

    public void removeAction(ContextFreeRule rule) {
        this.actionMap.remove(rule);
    }

    protected abstract ShBuiltInCommands getCommands();

    protected abstract String getResourceName();

    public ShEnvironment getenv(DecultureOptions options) {
        ShRootEnvironment env = new ShRootEnvironment();
        char[] a = options.getOutputFilename().toCharArray();
        a[0] = Character.toUpperCase(a[0]);
        env.bind("IFS", " \t");
        env.bind("CLASSNAME", new String(a));
        env.bind("FILENAME", options.getFilename());
        env.bind("OUTPUT_FILENAME", options.getOutputFilename());
        env.bind("ERROR_CLASS", "RuntimeException");
        env.bind("INIT_STATE_ID", String.valueOf(this.lr.getTable().getInitialStateID()));
        return env;
    }

    @Override
    public void translate(PrintStream ous, DecultureOptions options) throws IOException {
        try (InputStream ins = null;){
            try {
                ins = LRObject.class.getResourceAsStream(this.getResourceName());
                ShBuiltInCommands cmd = this.getCommands();
                DecultureFileSystem fs = new DecultureFileSystem(this.lr.getDefinition().getDefinition(), this.lr.getInput());
                DefaultShRuntime run = new DefaultShRuntime(cmd);
                XtraceStream qs = new XtraceStream(System.out);
                ShEnvironment env = this.getenv(options);
                ShFacade.execute(env, (ShFileSystem)fs, cmd, (ShRuntime)run, ins, System.in, ous, System.err, qs);
            }
            catch (ShSyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public int howManyShiftReduceConflicts() {
        int r = 0;
        for (LRConflict t : this.lr.getTable().getConflicts()) {
            r += t.isShiftReduce() ? 1 : 0;
        }
        return r;
    }

    @Override
    public int howManyReduceReduceConflicts() {
        int r = 0;
        for (LRConflict t : this.lr.getTable().getConflicts()) {
            r += t.isReduceReduce() ? 1 : 0;
        }
        return r;
    }
}

