/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import net.morilib.sh.ShRedirectType;
import net.morilib.sh.ShToken;

public class ShRedirector
extends ShToken {
    public static final ShRedirector IN = new ShRedirector(ShRedirectType.IN, 0, -1);
    public static final ShRedirector OUT = new ShRedirector(ShRedirectType.OUT, 1, -1);
    public static final ShRedirector APPEND = new ShRedirector(ShRedirectType.APPEND, 1, -1);
    private ShRedirectType type;
    private int source;
    private int destination;
    private String document;

    public ShRedirector(ShRedirectType type, int source, int destination) {
        this.type = type;
        this.source = source;
        this.destination = destination;
        this.document = null;
    }

    public ShRedirector(String document) {
        this.type = ShRedirectType.IN;
        this.source = 0;
        this.destination = -1;
        this.document = document;
    }

    public ShRedirectType getType() {
        return this.type;
    }

    public int getFDSource() {
        return this.source;
    }

    public int getFDDestination() {
        return this.destination;
    }

    public String getDocument() {
        return this.document;
    }

    public boolean isAppend() {
        return this.type.equals((Object)ShRedirectType.APPEND);
    }

    @Override
    public boolean isFileRedirector() {
        return this.destination < 0 && this.document == null;
    }

    @Override
    public boolean isDescriptorCopier() {
        return this.destination >= 0;
    }

    @Override
    public boolean isHereDocument() {
        return this.document != null;
    }

    public int hashCode() {
        int r = 17;
        r = 31 * this.type.hashCode() + r;
        r = 31 * this.source + r;
        r = 31 * this.destination + r;
        return r;
    }

    public boolean equals(Object o) {
        if (o instanceof ShRedirector) {
            ShRedirector r = (ShRedirector)o;
            return this.type.equals((Object)r.type) && this.source == r.source && this.destination == r.destination;
        }
        return false;
    }

    public String toString() {
        if (this.document != null) {
            return this.document;
        }
        if (this.source < 0) {
            return "&>";
        }
        if (this.destination < 0) {
            return String.valueOf(this.source) + this.type.toString();
        }
        return String.valueOf(this.source) + this.type.toString() + "&" + this.destination;
    }
}

