/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import net.morilib.sh.ShBuiltInCommands;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShParser;
import net.morilib.sh.ShRuntime;
import net.morilib.sh.ShSignal;
import net.morilib.sh.ShSyntaxException;
import net.morilib.sh.ShToken;
import net.morilib.sh.ShTree;
import net.morilib.sh.ShTreeExpressionMachine;
import net.morilib.sh.ShTrees;
import net.morilib.sh.misc.XtraceStream;

public class ShTreeSource
implements ShTree {
    private ShToken filename;

    public ShTreeSource(ShToken filename) {
        this.filename = filename;
    }

    @Override
    public int eval(ShEnvironment env, ShFileSystem fs, ShBuiltInCommands cmds, ShRuntime run, InputStream in, PrintStream out, PrintStream err, XtraceStream pr) throws IOException, ShSyntaxException {
        String s = ShTrees.substitute(env, run, fs, err, pr, this.filename);
        InputStream i = null;
        try {
            if (this.filename == null) {
                err.println("script not specified");
                return 72;
            }
            i = fs.getFile(s).getInputStream();
            ShTree p = ShTrees.compile(ShParser.parse(i, env.getCharset()));
            int n = p.eval(env, fs, cmds, run, in, out, err, pr);
            return n;
        }
        finally {
            String z;
            if (i != null) {
                i.close();
            }
            if ((z = env.getTrap(ShSignal.RETURN)) != null) {
                run.eval(env, fs, in, out, err, pr, z);
            }
        }
    }

    @Override
    public void compileInternally(ShTreeExpressionMachine.Builder b, Object brk, Object cnt) {
        b.add(this);
    }
}

