/*
 * Decompiled with CFR 0.152.
 */
package com.ranfa.lib;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.NtpV3Packet;
import org.apache.commons.net.ntp.TimeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JST {
    private static final Logger LOG = LoggerFactory.getLogger(JST.class);
    private static final String SERVER_NAME = "ntp.nict.jp";

    private JST() {
    }

    public static Date JSTNow() throws IOException {
        NTPUDPClient client = new NTPUDPClient();
        InetAddress address = InetAddress.getByName(SERVER_NAME);
        client.open();
        TimeInfo info = client.getTime(Objects.requireNonNull(address));
        info.computeDetails();
        LOG.debug("NTPClient: {}", (Object)client);
        LOG.debug("NetAddress: {}", (Object)address);
        LOG.debug("Time info: {}", (Object)info);
        return JST.validate(info);
    }

    private static Date validate(TimeInfo info) {
        NtpV3Packet packet = info.getMessage();
        long t1 = packet.getOriginateTimeStamp().getTime();
        long t2 = packet.getReceiveTimeStamp().getTime();
        long t3 = packet.getTransmitTimeStamp().getTime();
        long t4 = info.getReturnTime();
        long CalculatedOffset = (t2 - t1 + t3 - t4) / 2L;
        long receiveOffset = info.getOffset();
        long offset = (CalculatedOffset + receiveOffset) / 2L;
        Date date = new Date(System.currentTimeMillis() + offset);
        LOG.debug("Client originate Time: {}", (Object)t1);
        LOG.debug("Server Received request Time: {}", (Object)t2);
        LOG.debug("Server Transmit response Time: {}", (Object)t3);
        LOG.debug("Client Received response Time: {}", (Object)t4);
        LOG.info("Estimated time offset: {}", (Object)CalculatedOffset);
        LOG.info("received time offset: {}", (Object)receiveOffset);
        LOG.info("estimated JST: {}", (Object)date);
        LOG.info("Current client date: {}", (Object)new Date(System.currentTimeMillis()));
        return date;
    }
}

