class Admin::CrontabController < ApplicationController
  layout 'admin'

  def index
    list
    render :action => 'list'
  end

  # GETs should be safe (see http://www.w3.org/2001/tag/doc/whenToUseGet.html)
  verify :method => :post, :only => [ :destroy, :create, :update ],
         :redirect_to => { :action => :list }

  def list
    @crontab_pages, @crontabs = paginate :crontabs, :per_page => 10
  end

  def show
    @crontab = Crontab.find(params[:id])
  end

  def new
    @crontab = Crontab.new
  end

  def create
    @crontab = Crontab.new(params[:crontab])
    if @crontab.save
      flash[:notice] = 'Crontab was successfully created.'
      redirect_to :action => 'list'
    else
      render :action => 'new'
    end
  end

  def edit
    @crontab = Crontab.find(params[:id])
  end

  def update
    @crontab = Crontab.find(params[:id])
    if @crontab.update_attributes(params[:crontab])
      flash[:notice] = 'Crontab was successfully updated.'
      redirect_to :action => 'show', :id => @crontab
    else
      render :action => 'edit'
    end
  end

  def destroy
    Crontab.find(params[:id]).destroy
    redirect_to :action => 'list'
  end
end
