class Admin::ItemController < ApplicationController
  layout 'admin'

  def index
    list
    render :action => 'list'
  end

  # GETs should be safe (see http://www.w3.org/2001/tag/doc/whenToUseGet.html)
  verify :method => :post, :only => [ :destroy, :create, :update ],
         :redirect_to => { :action => :list }

  def reset
    session[:items] = nil
    params[:keyword] = ''
    list
    render :action => 'list'
  end

  def list
    if session[:items].nil? || session[:items].size < 1 || !params[:keyword].blank?
      session[:keyword] = params[:keyword]
      session[:items] = Item.find( :all, :conditions => "item_name LIKE '%#{ERB::Util.h(session[:keyword])}%'", :include =>[:material, :item_type], :order => 'item_id ASC' )
    end
    if params[:per_page].to_i > 0
      session[:per_page] = params[:per_page].to_i
    else
      session[:per_page] = 10
    end
    @pager = ::Paginator.new( session[:items].size, session[:per_page] ) do |offset, per_page|
      session[:items][offset...(offset + per_page)]
    end
    @page = @pager.page( params[:page] )
    @page = [] unless @page
    @keyword = session[:keyword]
  end

  def show
    @item = Item.find(params[:id], :include => [:material, :item_type])
    @picks = LocationPick.find( :all, :conditions => ['item_id = ?', @item.id] , :include => :location )
    @shops = ShopStock.find( :all, :conditions => ['item_id = ?', @item.id], :include => :location )
    @usernum = User.getUserNum
  end

  def new
    @item = Item.new
    @types = ItemType.find(:all)
  end

  def create
    @types = ItemType.find(:all)
    material = Material.find_by_material_name( params[:material_name] )
    unless material
      render :action => 'new'
      return nil
    end
    params[:item][:item_material_id] = material.id

    @item = Item.new(params[:item])
    if @item.save
      flash[:notice] = 'Item was successfully created.'
      redirect_to :action => 'list'
    else
      render :action => 'new'
    end
  end

  def edit
    @item = Item.find(params[:id])
    @types = ItemType.find(:all)
  end

  def update
    @item = Item.find(params[:id])
    material = Material.find_by_material_name( params[:material_name] )
    unless material
      flash.now[:notice] = "ʬ '#{params[:material_name]}' Ǥ"
      edit
      render :action => 'edit'
      return nil
    end
    params[:item][:item_material_id] = material.id
    params[:item][:item_action] = nil if params[:item][:item_action].blank?
    if @item.update_attributes(params[:item])
      flash[:notice] = 'Item was successfully updated.'
      redirect_to :action => 'show', :id => @item
    else
      edit
      render :action => 'edit'
    end
  end

  def destroy
    Item.find(params[:id]).destroy
    redirect_to :action => 'list'
  end
end
