class Admin::ItemTypeController < ApplicationController
  layout 'admin'

  def index
    list
    render :action => 'list'
  end

  # GETs should be safe (see http://www.w3.org/2001/tag/doc/whenToUseGet.html)
  verify :method => :post, :only => [ :destroy, :create, :update ],
         :redirect_to => { :action => :list }

  def list
    @item_type_pages, @item_types = paginate :item_types, :per_page => 10
  end

  def show
    @item_type = ItemType.find(params[:id])
  end

  def new
    @item_type = ItemType.new
  end

  def create
    @item_type = ItemType.new(params[:item_type])
    if @item_type.save
      flash[:notice] = 'ItemType was successfully created.'
      redirect_to :action => 'list'
    else
      render :action => 'new'
    end
  end

  def edit
    @item_type = ItemType.find(params[:id])
  end

  def update
    @item_type = ItemType.find(params[:id])
    if @item_type.update_attributes(params[:item_type])
      flash[:notice] = 'ItemType was successfully updated.'
      redirect_to :action => 'show', :id => @item_type
    else
      render :action => 'edit'
    end
  end

  def destroy
    ItemType.find(params[:id]).destroy
    redirect_to :action => 'list'
  end
end
