class Admin::LocationPickController < ApplicationController
  layout 'admin'

  def index
    list
    render :action => 'list'
  end

  # GETs should be safe (see http://www.w3.org/2001/tag/doc/whenToUseGet.html)
  verify :method => :post, :only => [ :destroy, :create, :update ],
         :redirect_to => { :action => :list }

  def list
    @location_pick_pages, @location_picks = paginate :location_picks, :per_page => 10
  end

  def show
    @location_pick = LocationPick.find(params[:id])
  end

  def new
    @location_pick = LocationPick.new
  end

  def create
    params[:location_pick][:location_id] = LocationPick.location_from_name( params[:location_str] )
    params[:location_pick][:item_id] = LocationPick.item_from_name( params[:item_str] )
    @location_pick = LocationPick.new(params[:location_pick])
    if @location_pick.save
      flash[:notice] = 'LocationPick was successfully created.'
      redirect_to :action => 'list'
    else
      render :action => 'new'
    end
  end

  def edit
    @location_pick = LocationPick.find(params[:id])
  end

  def update
    params[:location_pick][:location_id] = LocationPick.location_from_name( params[:location_str] )
    params[:location_pick][:item_id] = LocationPick.item_from_name( params[:item_str] )
    @location_pick = LocationPick.find(params[:id])
    if @location_pick.update_attributes(params[:location_pick])
      flash[:notice] = 'LocationPick was successfully updated.'
      redirect_to :action => 'show', :id => @location_pick
    else
      render :action => 'edit'
    end
  end

  def destroy
    LocationPick.find(params[:id]).destroy
    redirect_to :action => 'list'
  end
end
