require 'digest/md5'

class Admin::MaterialController < ApplicationController
  layout 'admin'

  def index
    list
    render :action => 'list'
  end

  # GETs should be safe (see http://www.w3.org/2001/tag/doc/whenToUseGet.html)
  verify :method => :post, :only => [ :destroy, :create, :update ],
         :redirect_to => { :action => :list }

  def list
    @material_pages, @materials = paginate :materials, :per_page => 10
  end

  def show
    @material = Material.find(params[:id])
  end

  def new
    @material = Material.new
  end

  def create
    params[:material][:material_hash] = Digest::MD5.hexdigest( params[:material][:material_name] )
    @material = Material.new(params[:material])
    if @material.save
      flash[:notice] = 'Material was successfully created.'
      redirect_to :action => 'list'
    else
      render :action => 'new'
    end
  end

  def destroy
    Material.find(params[:id]).destroy
    redirect_to :action => 'list'
  end
end
