# Methods added to this helper will be available to all templates in the application.

module ApplicationHelper
  def self.order_abort_charge; 0.1; end
  def self.order_cancel_charge; 0.2; end
  def self.order_delay_charge; 0.3; end
  def self.money_unit; ''; end

  def item_types_list
    spacer = ' '
    item_types = ItemType.find(:all, :order => 'item_type_id ASC')
    selected = false
    str = item_types.collect do |type|
      if session[:select_type] == type.id
        selected = true
        type.item_type_name
      else
        link_to( type.item_type_name, :select_type => type.id )
      end
    end.join(spacer)
    str += spacer + (selected ? link_to('', :select_type => 0) : '')
  end

  def rest_items(items, header = "")
    str = ""
    return str if items.nil? or items.size < 1
    str += '<table border="1">' +
      '<tr>' +
      '<th>̾</th>' +
      '<th></th>' +
      '<th>ʬ</th>' +
      '<th></th>' +
      '<th></th>' +
      header +
      '</tr>'
    odd_or_even = 0
    items.each do |item|
      odd_or_even = 1 - odd_or_even
      str += %Q(<tr class="itemdata#{odd_or_even}">) +
        "<td>#{item.item_name}</td>" +
        "<td>#{item.item_type.item_type_name}</td>" +
        "<td>#{item.material.material_name}</td>" +
        "<td>#{item.num(@user.id)}</td>" +
        "<td>#{item.description}</td>"
      (str += yield( item )) if block_given?
      str += "</tr>"
    end
    str += '</table>'
    return str
  end

  def location_breadcrum
    list = []
    l = @user.location
    list.unshift( l.location_name )
    index = l.parent_id.to_i
    while index > 0
      l = Location.find( index )
      list.unshift( yield( l ) )
      index = l.parent_id.to_i
    end
    list.join " >> "
  end
  def link_to_if_mark( exist, txt, url, ok = "", ng = "")
    link_to_if( exist, txt, url ) + if_mark(exist ,ok ,ng)
  end
  def if_mark( exist, ok = "", ng = "" )
    exist ? ok : ng
  end

  def image_size(filename)
    require 'image_size'

    size = [ 0, 0 ]
    fn = File.expand_path "#{RAILS_ROOT}/public/#{filename}"
    begin
      open( fn, "rb" ) do |f|
        img = ImageSize.new( f )
        size = [ img.get_width, img.get_height ]
      end
    rescue => e
      flash.now[:info] = e.to_s
      logger.error( e )
    end
    return size
  end

  def fill_clickpoint(bg_file, pt_file)
    bgsize = image_size( bg_file )
    if bgsize[0] < 1 || bgsize[1] < 1
      flash.now[:error] = "ե #{bg_file} ɤ߹ߤ˼Ԥޤ<br />ԤϢ򤪴ꤤޤ"
      return ""
    end
    ptsize = image_size( pt_file )
    if ptsize[0] < 1 || ptsize[1] < 1
      flash.now[:error] = "ե #{pt_file} ɤ߹ߤ˼Ԥޤ<br />ԤϢ򤪴ꤤޤ"
      return ""
    end

    ret = []
    tag = image_tag(File.basename(bg_file))
    m = /src="([^"]+)\?/.match( tag )
    bgfn = m[1] if m
    ret << %Q(<table border="0" width="#{bgsize[0]}" height="#{bgsize[1]}" style="background-image: url(#{bgfn});" cellspacing="0" cellpadding="0">)
    count = 1
    d, m = *bgsize[1].divmod( ptsize[1] )
    (d - (m != 0 ? 0 : 1)).times do |y|
      ret << %Q(<tr height="#{ptsize[1]}px">)
      d2, m2 = *bgsize[0].divmod( ptsize[0] )
      (d2 - (m2 != 0 ? 0 : 1)).times do |x|
        ret << <<"eod"
<td>
<a href="#{url_for :action => 'pick', :click => count}">
#{image_tag(File.basename(pt_file), :border => "0", :style => "margin: 0px 0px 0px 0px; padding: 0px 0px 0px 0px;")}
</a>
</td>
eod
        count += 1
      end
      ret << "</tr>"
    end
    ret << "</table>"
    return ret.join( "\n" )
  end
end
