class Experience < ActiveRecord::Base
  belongs_to :user
  belongs_to :item

  def self.blended?(user, item)
    r = self.find( :first, :conditions => ['user_id = ? and item_id = ?',
                                           user, item] )
    return r ? true : false
  end
  def self.can_blend(user)
    return self.find( :all, :conditions => ['user_id = ?', user] ).collect{|b| b.item_id }
  end
  def self.add(user, item)
    self.create( :user_id => user, :item_id => item ) unless blended?(user, item)
  end
  def self.count(user)
    r = self.find( :all, :conditions => ['user_id = ?', user] )
    return r ? r.size : 0
  end
end
