class GuildOrder < ActiveRecord::Base
  OrderAmountMax = 99
  SystemOrderMax = 20 # max size of undone order from system

  # 󽷤ʧˤʤäƤ

  belongs_to :owner, :class_name => 'User', :foreign_key => 'owner_id'
  belongs_to :worker, :class_name => 'User', :foreign_key => 'worker_id'
  belongs_to :item
  belongs_to :location

  def self.make_order( user, item, amount, price, dead_interval )
    if user.location.has_guild?
      if Stock.find_by_user_id_and_item_id( user.id, item.id )
        if user.user_money >= price
          deadline = Time.now + dead_interval * 3600 if dead_interval > 0
          transaction do
            self.create!( :location_id => user.location.id,
                          :owner_id => user.id,
                          :item_id => item.id,
                          :amount => amount > OrderAmountMax ? OrderAmountMax : amount,
                          :price => price,
                          :deadline => deadline
                          )
            user.pay( price )
            user.save!
          end
          true
        else
          raise "⤬󽷳ۤ­ޤ"
          false
        end
      else
        raise "򤷤ƥबǤ"
        false
      end
    else
      raise "ˤϥɻޤ"
      false
    end
  end

  def self.cancel_order( user, order ) # ʸԤΥ󥻥
    return if order.owner_id && user.id != order.owner_id
    if order.owner == nil
      # order from system
      if order.worker_id?
        penalty = ( order.price * ApplicationHelper::order_cancel_charge ).ceil
        order.worker.income( penalty )
        order.worker.save!
        order.worker.sendMessage( order.owner_id, "겼", "#{order.item.item_name}Ĵã꤬겼ޤ<br />#{penalty}#{ApplicationHelper::money_unit}ޤ")
      end
      order.done = true
      order.save!
    elsif order.worker == nil
      transaction do
        order.owner.income( order.price )
        order.owner.save!
        order.done = true
        order.save!
      end
    elsif order.is_delay
      transaction do
        order.owner.income( order.price )
        order.owner.save!
        order.done = true
        order.save!
        order.worker.sendMessage( order.owner_id, "겼", "#{order.owner.user_name}#{order.item.item_name}Ĵã꤬겼ޤ<br />¤᤮Ƥ뤿ᡢޤ")
      end
    else
      transaction do
        penalty = ( order.price * ApplicationHelper::order_cancel_charge ).ceil
        order.worker.income( penalty )
        order.worker.save!
        order.owner.income(order.price - penalty)
        order.owner.save!
        order.done = true
        order.save!
        order.worker.sendMessage( order.owner_id, "겼", "#{order.owner.user_name}#{order.item.item_name}Ĵã꤬겼ޤ<br />#{penalty}#{ApplicationHelper::money_unit}ޤ")
      end
    end
  end

  def self.contract( user_id, order_id )
    ret = false
    order = self.find( order_id )
    if order
      transaction do
        if order.worker == nil
          order.worker_id = user_id
          order.save!
          if order.owner
            order.owner.sendMessage( order.worker_id, "", "#{order.worker.user_name}#{order.item.item_name}Ĵã󤷤ޤ" )
          end
          ret = true
        end
      end # transaction
    end
    return ret
  end

  def self.abort_order( user, order ) # ԤΥ󥻥
    return if order.worker_id != user.id
    isDelay = order.is_delay
    penalty = ( order.price * ApplicationHelper::order_abort_charge * (isDelay ? 2 : 1) ).ceil
    if order.owner == nil && order.worker?
      transaction do
        order.worker.pay( penalty )
        order.worker.incr_cancel
        order.worker.save!
        order.worker_id = nil
        order.save!
      end
    elsif order.worker == nil
      transaction do
        order.owner.income( penalty )
        order.owner.save!
        order.worker_id = nil
        order.save!
        order.owner.sendMessage( nil, "ꥭ󥻥", "󤷤Ƥ#{order.item.item_name}Ĵã꤬󥻥뤵ޤ<br />#{penalty}#{ApplicationHelper::money_unit}ޤ")
      end
    else
      transaction do
        penalty = order.worker.pay( penalty )
        order.worker.incr_cancel
        order.worker.save!
        order.owner.income( penalty )
        order.owner.save!
        order.worker_id = nil
        order.save!
        order.owner.sendMessage( order.worker_id, "ꥭ󥻥", "#{order.worker.user_name}󤷤Ƥ#{order.item.item_name}Ĵã꤬󥻥뤵ޤ<br />#{penalty}#{ApplicationHelper::money_unit}ޤ")
      end
    end
  end

  def self.close_order( user, order )
    return false if order.worker_id != user.id
    penalty = 0
    add_msg = ""
    if order.is_delay
      penalty = order.price * ApplicationHelper::order_delay_charge
      add_msg = "<br />ڤвᤷƤᡢٱ»#{penalty}#{ApplicationHelper::money_unit}ޤ"
    end
    s = Stock.find(:first, :conditions => ['user_id = ? AND item_id = ?',
                                           order.worker_id, order.item_id] )
    if s and s.stock >= order.amount
      transaction do
        s.stock -= order.amount
        s.save!
        if order.owner
          order.owner.income( penalty ) if penalty > 0
          Stock.incr( order.owner_id, order.item_id, order.amount )
          order.owner.sendMessage(order.worker_id, "ã", "#{order.worker.user_name}󤷤ƤĴã꤬ãޤ<br />#{order.item.item_name}#{order.amount}ñޤ#{add_msg}")
        end
        order.worker.income( order.price - penalty )
        order.worker.incr_success
        order.worker.save!
        order.done = true
        order.save!
      end
      true
    else
      false
    end
  end

  def self.process_system_order
    self.remove_system_order
    self.make_system_order
  end

  def self.remove_system_order
    # ̤Ƥΰϴ¤礦ɤǾä
    self.find( :all, :conditions => ['done = FALSE AND owner_id IS NULL AND worker_id IS NULL AND deadline < ?', Time.now] ).each do |o|
      self.cancel_order( nil, o )
    end
    # ƺѤߤΰϰַвᤷƤä
    self.find( :all, :conditions => ['done = FALSE AND owner_id IS NULL AND deadline < ?', 12.hours.ago] ).each do |o|
      self.cancel_order( nil, o )
    end
  end

  def self.make_system_order
    if self.count(:conditions => ['done = FALSE AND owner_id IS NULL']) < SystemOrderMax
      (rand(4) + 1).times do
        make_random_order
      end
    end
    true
  end

  def is_delay(time = Time.now)
    return (deadline ? deadline < time : false)
  end

  private

  def self.make_random_order
    i = Item.get_random_item_under_price(300)
    num = rand(20) + 1
    # 50% ... 150% sell price( price / 2.0 )
    price = (i.item_price / 2.0 * num * ( rand(10) - 5 + 10 ) / 10.0).ceil
    # deadline setting
    deadline_interval = rand(48) + 1
    price += (price * ((50 - deadline_interval).div(10) - 1) / 10.0).ceil

    loc = Location.get_random_location_has_guild( true )

    self.create( :location_id => loc.id,
                 :owner_id => nil,
                 :item_id => i.id,
                 :amount => num,
                 :price => price,
                 :deadline => Time.now + deadline_interval * 3600
                 )
  end
end
