class Location < ActiveRecord::Base
  has_many :location_picks
  has_many :items, :through => :location_picks
  has_many :shop_stocks, :class_name => 'ShopStock', :foreign_key => 'location_id'
  has_many :users, :foreign_key => 'user_location'

  def parent_name
    return '' if parent_id.nil?
    self.class.find( parent_id ).location_name
  end

  def self.parent_id_from_name(name)
    return 1 if name == ''
    l = self.find_by_location_name( name )
    return 1 unless l
    l.id
  end

  def self.get_random_location_has_guild(has_guild)
    loop do
      index = rand( self.count.to_i ) + 1
      loc = self.find( index )
      if loc.has_guild? == !!has_guild
        return loc
      end
    end
  end
end
