class LocationMonster < ActiveRecord::Base
  belongs_to :location
  belongs_to :monster

  def location_name
    return '' unless location_id?
    location.location_name
  end

  def monster_name
    return '' unless monster_id?
    monster.name
  end

  def self.monster_from_name(name)
    m = Monster.find_by_name( name )
    m && m.id
  end
  def self.location_from_name(name)
    l = Location.find_by_location_name(name)
    l && l.id
  end

  def self.has_monster?(loc_id)
    return !!self.find_by_location_id(loc_id)
  end

  def self.get_monster_id(loc_id)
    @monsters = self.find_all_by_location_id( loc_id )
    return nil if @monsters.size < 1
    total_prob = 0
    @monsters.each{|m| total_prob += m.probability}
    rnd = rand(total_prob) + 1
    ret = nil
    @monsters.each do |m|
      rnd -= m.probability
      if rnd < 1
        ret = m.monster_id
        break
      end
    end
    return ret
  end
end
