class ShopStock < ActiveRecord::Base
  belongs_to :location
  belongs_to :item

  def location_name
    return '' unless location_id?
    location.location_name
  end

  def item_name
    return '' unless item_id?
    item.item_name
  end

  def self.location_from_name(name)
    l = Location.find_by_location_name(name)
    l && l.id
  end

  def self.item_from_name(name)
    i = Item.find_by_item_name(name)
    i && i.id
  end

  def self.supply_shop_stocks
    usernum = User.getUserNum
    stocks = self.find( :all )
    stocks.each do |stock|
      left = stock.stock
      max = (stock.maximum * usernum / 100).to_i
      stock.rest += stock.supply * usernum
      stock.stock += (stock.rest / 100).to_i
      stock.rest = stock.rest % 100
      if stock.stock > max
        stock.stock = left
        stock.rest = 0
      end
      stock.save
    end
    true
  end
end
