class LoginController < ApplicationController
  skip_before_filter :check_authentication

  def login
    if request.post?
      session[:user_id] = User.authenticate(params[:username], params[:password]).id
      if session[:intended_action]
        redirect_to( :action => session[:intended_action],
                     :controller => session[:intended_controller]
                     )
      else
        redirect_to( :action => 'home', :controller => 'game' )
      end
    end
  rescue
    flash[:error] = "桼̾ѥɤ㤤ޤ"
  end

  def logout
    session[:user_id] = nil
  end

  def add_standard_material(user_id)
    items = Item.find_by_sql( 'select * from items where item_id not in (select recipe_result_id from recipes)' )
    items.each do |i|
      Experience.create( :user_id => user_id, :item_id => i.item_id )
    end
  end

  def new_account
    if not request.post?
    elsif not params[:username] or not params[:password] or not params[:confirm]
      flash[:error] = "ƤϤƤ"
    elsif params[:password] != params[:confirm]
      flash[:error] = "ѥɤפƤޤ"
    else
      u = User.find_by_user_name( params[:username] )
      if u
        flash[:error] = "̾ʣƤޤ̤̾ǻƤ"
      else
        n = 1 + User.count
        @u = User.new
        @u[:user_name] = params[:username]
        @u[:user_start] = Time.now
        @u[:user_id] = n
        @u.user_pass = params[:password]
        if @u.save
          add_standard_material( @u.id )
          render 'login/registed'
        else
          flash[:error] = "ѥɤ˼Ԥޤ"
          @u.destroy
        end
      end
    end
  end

end
