class Experience < ActiveRecord::Base
  belongs_to :user, :foreign_key => 'user_id'
  belongs_to :item, :foreign_key => 'item_id'

  def item_name
    item.item_name
  end
  def item_type
    item.item_type
  end
  def material
    item.material
  end
  def description
    item.description
  end

  def self.blended?(user, item)
    r = self.find( :first, :conditions => ['user_id = ? and item_id = ?',
                                           user, item] )
    return r ? true : false
  end
  def self.can_blend(user)
    return self.find( :all, :conditions => ['user_id = ?', user] ).collect{|b| b.item_id }
  end
  def self.add(user, item)
    self.create( :user_id => user, :item_id => item ) unless blended?(user, item)
  end
  def self.count(user)
    r = self.find( :all, :conditions => ['user_id = ?', user] )
    return r ? r.size : 0
  end
end
