require 'digest/sha2'

class User < ActiveRecord::Base
  set_primary_key "user_id"

  validates_uniqueness_of :user_name

  STANDARD_ITEMS = []
  USER_MONEY_MAX = 100 * 10000

  def user_pass=(pass)
    salt = [Array.new(6){rand(256).chr}.join].pack("m").chomp
    self.user_salt, self.user_pass_hash =
      salt, Digest::SHA256.hexdigest(pass + salt)
  end

  def self.authenticate(username, password)
    user = User.find(:first, :conditions => ['user_name = ?', username])
    if user.blank? ||
        Digest::SHA256.hexdigest(password + user.user_salt) != user.user_pass_hash
      raise "Username or password invalid"
    end
    user
  end

  def location_name
    return ''
  end

  def get_item_by_name(name, num)
    item = Item.find_by_item_name( name )
    get_item( item.id, num ) if item
  end

  def self.getUserNum
    User.count.to_i
  end

end

def min(v1, v2)
  return (v1 < v2) ? v1 : v2
end
def max(v1, v2)
  return (v1 > v2) ? v1 : v2
end
