class InitialState < ActiveRecord::Migration
  def self.up
    create_table :users, :id => false, :primary_key => 'user_id' do |t|
      t.column :user_id, :primary_key
      t.column :user_name, :string
      t.column :user_salt, :string
      t.column :user_pass_hash, :string
      t.column :user_money, :integer
      t.column :user_start, :timestamp
      t.column :user_location, :integer
    end

    create_table :stocks, :id => false, :primary_key => 'stock_id' do |t|
      t.column :stock_id, :primary_key
      t.column :user_id, :integer
      t.column :item_id, :integer
      t.column :stock, :integer, :default => 0
    end
    add_index :stocks, :user_id
  end

  def self.down
    remove_index :stocks, :column => :user_id
    drop_table :users
    drop_table :stocks
  end
end
