class CreateShopStocks < ImportMigration
  def self.up
    create_table :shop_stocks do |t|
      # t.column :name, :string
      t.column :shop_id, :integer, :null => false
      t.column :item_id, :integer, :null => false
      t.column :stock, :integer, :default => 0
      t.column :price, :integer
      t.column :supply, :integer
      t.column :maximum, :integer
      t.column :rest, :integer
    end
    do_file_import( "input_shop_stock.csv" ) do |arr|
      item_id = Item.find_by_item_name( arr[1] ).id
      ShopStock.create( :shop_id => Shop.find_by_shop_name( arr[0] ).id,
                        :item_id => item_id,
                        :stock => 0,
                        :price => Item.find( item_id ).item_price,
                        :maximum => arr[2].to_i,
                        :supply => arr[3].to_i,
                        :rest => 0
                        )
    end
  end

  def self.down
    drop_table :shop_stocks
  end
end
