/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.enjoybase.servlet;

import java.io.*;
import javax.servlet.http.*;
import com.enjoybase.*;
import com.enjoybase.model.*;

public class EditManifestServlet extends BaseServlet {
	protected String getURL(HttpServletRequest request) {
		return "./";
	}

	protected void disp(User user, Enjoybase base, PrintWriter out, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if(!user.isEditor()) {
			out.println("OCĂ܂B");
			return;
		}

		Manifest manifest = Enjoybase.getInstance().getManifest();

		out.println("<form method=post action=\"./cmd?cmdid=editmanifestresult\">");
		out.println("<input type=\"hidden\" name=\"prev\" value=\"./\">");
		out.println("<input type=\"hidden\" name=\"prevrev\" value=\"" + manifest.rev + "\">");

		out.print("<textarea name=\"detail\" cols=80 rows=20>");

		out.print(Enjoybase.toHtmlTextArea(manifest.text));

		out.println("</textarea>");
		
        out.println("<input type=submit value=\"XV\">");
		out.println("</form>");
		
		if(!user.isAdmin()) return;
	}
}
