/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.enjoybase.servlet;

import java.io.*;
import java.text.*;
import java.math.*;
import java.util.*;

import javax.servlet.http.*;

import com.enjoybase.*;
import com.enjoybase.model.*;

public class ManagerServlet extends BaseServlet {
	protected String getURL(HttpServletRequest request) {
		return "./manage";
	}

	protected void disp(User user, Enjoybase base, PrintWriter out, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if(!user.isEditor()) return;

		Storage store = new Storage();
		
		dispChangePassword(store, out, request, response);
		out.println("<hr>");
		dispUnregisterUser(store, out, request, response);
		out.println("<hr>");
		out.println("<i>ȍ~̍ڂ͊Ǘ҂ɏ𓾂Ă痘pĂB</i>");
		out.println("<hr>");
		dispUsageText(store, out, request, response);
		out.println("<hr>");
		dispNewUser(store, out, request, response);
		out.println("<hr>");
		dispEditLock(store, out, request, response);
		out.println("<hr>");
		dispImpersonate(store, out, request, response);
		out.println("<hr>");
		dispDefrag(store, out, request, response);
		
		store.close();
	}

	private void dispUsageText(Storage store, PrintWriter out, HttpServletRequest request, HttpServletResponse response) throws Exception {
		String rootDir = request.getSession().getServletContext().getInitParameter("FilesDir");
		String fileName = rootDir + "usage.html";
		
		BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(fileName), "MS932"));
		String text = "";
		String line;
		
		int lineNum = 0;
		
		while((line = reader.readLine()) != null) {
			text = text + line + "\n";
			lineNum++;
		}
		
		reader.close();

		out.println("pK̍XVF");
		out.println("<form method=post action=\"./cmd?cmdid=editusage\">");
		out.println("<input type=\"hidden\" name=\"prev\" value=\"./manage\">");

		out.print("<textarea name=\"usageText\" cols=80 rows=5>");
		out.print(Enjoybase.toHtmlTextArea(text));
		out.println("</textarea>");
		
        out.println("<input type=submit value=\"XV\">");
		out.println("</form>");
	}

	private void dispNewUser(Storage store, PrintWriter out, HttpServletRequest request, HttpServletResponse response) throws Exception {
		out.println("VK[Uo^F");
		out.println("<form method=post action=\"./cmd?cmdid=registeruser\">");
		out.println("[UID: <input type=text name=userid><br>");
		out.println("pX[h:  <input type=password name=password><br>");
		out.println("pX[hē:  <input type=password name=password2><br>");
		out.println("<input type=submit value=\"o^\">");
		out.println("</form>");
		out.println("pX[h͔ppA[U͔ppуA_[Cgp\łB<br>");
		out.println("ꂼ315̊Ԃœ͂ĂB<br><br>");

		String pwdchars = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
		String pwd = "";

		Random rand = new Random();
		
		for(int i=0; i<12; i++) {
			pwd = pwd + pwdchars.charAt(rand.nextInt(pwdchars.length()));
		}

		out.println("pX[hF " + pwd + "<br>");
	}

	private void dispChangePassword(Storage store, PrintWriter out, HttpServletRequest request, HttpServletResponse response) throws Exception {
		out.println("pX[hύXF");
		
		out.println("<form method=post action=\"./cmd?cmdid=changepassword\">");
		out.println("pX[h:  <input type=password name=password><br>");
		out.println("pX[hē:  <input type=password name=password2><br>");
		out.println("<input type=submit value=\"ύX\">");
		out.println("</form>");
		out.println("pX[h͔ppA[U͔ppуA_[Cgp\łB<br>");
		out.println("ꂼ315̊Ԃœ͂ĂB<br><br>");
	}

	private void dispEditLock(Storage store, PrintWriter out, HttpServletRequest request, HttpServletResponse response) throws Exception {
		out.println("ҏWbNԁF" + (Storage.editlock ? "bN" : "bN"));
		
		out.println("<form method=post action=\"./cmd?cmdid=toggleeditlock\">");
		out.println("<input type=\"hidden\" name=\"prev\" value=\"./manage\">");
		out.println("<input type=submit value=\"gO\">");
		out.println("</form>");
	}
	
	private void dispUnregisterUser(Storage store, PrintWriter out, HttpServletRequest request, HttpServletResponse response) throws Exception {
		String pwdchars = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
		String key = "";

		out.println("AJEg폜F<br>");
		out.print("둀h߁Au`FbNL[[hvɎ̂S̃L[[h͂ĉF");

		Random rand = new Random();

		for(int i=0; i<4; i++) {
			key = key + pwdchars.charAt(rand.nextInt(pwdchars.length()));
		}

		out.println("u" + key + "v<br>");

		out.println("<form method=post action=\"./cmd?cmdid=deleteuser\">");
		out.println("<input type=\"hidden\" name=\"prev\" value=\"./\">");
		out.println("<input type=\"hidden\" name=\"key\" value=\"" + key + "\">");
		out.println("`FbNL[[h:  <input type=text name=key2><br>");
		out.println("<input type=submit value=\"s\">");
		out.println("</form>");
	}
	
	private void dispImpersonate(Storage store, final PrintWriter out, HttpServletRequest request, HttpServletResponse response) throws Exception {
		out.println("Impersonate UserF<br>");

		store.walkUser(new UserWalker() {
			public boolean walk(User user) {
				out.println("<a href=\"./cmd?cmdid=impersonate&userid=" + user.userId
						+ "&prev=./\">" + user.userName +  "</a> ");

				return true;
			}
		});

		out.println("<br>");
	}

	private void dispDefrag(Storage store, final PrintWriter out, HttpServletRequest request, HttpServletResponse response) throws Exception {
		out.println("ftOF");

		out.println("<form method=post action=\"./cmd?cmdid=defrag\">");
		out.println("<input type=\"hidden\" name=\"prev\" value=\"./manage\">");
		out.println("<input type=submit value=\"s\">");
		out.println("</form>");
	}
}
