/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.enjoybase.servlet;

import java.io.*;
import java.text.SimpleDateFormat;

import javax.servlet.http.*;

import com.enjoybase.*;
import com.enjoybase.model.*;

public class TopicServlet extends BaseServlet {
	public String getURL(HttpServletRequest request) {
		return "./topic?id=" + request.getParameter("id");
	}

	public static SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");

	protected void disp(User user, Enjoybase base, PrintWriter out, HttpServletRequest request, HttpServletResponse response) throws Exception {
		int id = Integer.parseInt(request.getParameter("id"));
		int pageNo = 0;
		if(request.getParameter("page") != null) pageNo = Integer.parseInt(request.getParameter("page"));
	
		Storage store = new Storage();
		Topic topic = store.getTopic(id);

		if(topic == null) {
			out.println("<i>쐬</i>");
		} else {
			if(pageNo == 0) {
				out.println(topic.html);
			}
		}
		
		out.println("<br>");
		out.println("<i>̃y[W̍ŏIXVF" + df.format(topic.date) + " (" + topic.editor + ")</i>");

		if(pageNo > 0 && user.isGuest()) return;

		final PrintWriter fout = out;
		final User fuser = user;
		final int fid = id;

		boolean hasNextPage = store.walkComments(id, pageNo, new CommentWalker() {
			public boolean walk(Comment comment) {
				fout.println("<hr>");

				fout.println("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td>");
				fout.println("<a name=\"" + comment.commentId + "\"></a>");
				fout.print(comment.commentId + ". ");
				fout.print("<b>" + comment.userName + "</b> " + df.format(comment.date));

				if(fuser.isEditor() && comment.userName.equals(fuser.userName)) {
					fout.println("</td><td>");
					fout.println("<form method=post action=\"./cmd?cmdid=deletecomment\">");
					fout.println("<input type=\"hidden\" name=\"prev\" value=\"./topic?id=" + fid + "\">");
					fout.println("<input type=\"hidden\" name=\"commentid\" value=\""+ comment.commentId + "\">");
			        fout.println("<input type=submit value=\"DEL\">");
					fout.println("</form>");
				}
				fout.println("</td></tr></table>");

				fout.println(comment.text);
				
				return true;
			}
		});

		store.close();

		if(hasNextPage) {
			fout.println("<hr>");

			if(user.isEditor()) {
				out.println("<a href=\"./topic?id=" + id + "&page=" + (pageNo+1) + "\">Rg50</a><br>");
			} else {
				out.println("<i>(ŐV50݂̂\Ă܂)</i>");
			}
		}

		if(user.isEditor()) {
			fout.println("<hr>");
			out.println("<form method=post action=\"./cmd?cmdid=postcomment\">");
			out.println("<input type=\"hidden\" name=\"prev\" value=\"./topic?id=" + id + "\">");
			fout.println("<input type=\"hidden\" name=\"topicid\" value=\""+ id + "\">");
			out.println("<textarea name=comment cols=70 rows=3></textarea>");
			out.println("<input type=submit value=\"Rg\">");
			out.println("</form>");
		}
	}

	@Override protected void outOptionalHeader(User user, Enjoybase base, PrintWriter out, HttpServletRequest request) {
		if(user.isEditor()) {
			out.println("<a href=\"./edittopic?id=" + request.getParameter("id") + "\">ҏW</a>");
		}
	}
}
