/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.servlet;

import java.io.*;
import java.util.*;

import javax.servlet.*;
import javax.servlet.http.*;

import com.aibonware.inaver.*;
import com.aibonware.inaver.model.*;
import com.aibonware.inaver.store.*;
import com.aibonware.inaver.task.TaskStage;
import com.aibonware.inaver.task.ThreadCrawler;
import com.aibonware.inaver.url.*;
import com.aibonware.nvrlib.*;
import com.aibonware.nvrlib.model.*;

@SuppressWarnings("serial")
public class PostArticleServlet  extends HttpServlet {
	public PostArticleServlet() {}

	public static int tonum(String s) {
		try {
			return Integer.parseInt(s);
		} catch(Exception e) {
			return 0;
		}
	}

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		doGetOrPost(request, response, true);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		doGetOrPost(request, response, false);
	}

	private void doGetOrPost(HttpServletRequest request, HttpServletResponse response, boolean isFirst) {
		try {
			response.setContentType("text/html; charset=MS932");
			PrintWriter out = response.getWriter();

			INaver inaver = INaver.getInstance();
		
			if(inaver == null) {
				Log.err("service not running");
				out.println("service not running");
				out.close();
				return;
			}

			UserConfig user = null;
			HttpSession session = request.getSession(false);

			if(session != null) user = (UserConfig)session.getAttribute("userconfig");

			if(user == null) {
				out.println("OCĂ܂B");
			} else {
				SQLStoreProvider storeProvider = inaver.getStoreProvider();
				MasterStore store = storeProvider.openMasterStore();

				AuthServletContext ct = new AuthServletContext(
						user, 
						request, 
						response, 
						store, 
						inaver, 
						out, 
						new AuthUrl("postarticle", request));				
				
				dispContents(ct);

				store.close();
			}

		} catch(Exception e) {
			Log.err(e);

			try {
				PrintWriter out = response.getWriter();
				out.println(e.getMessage());
				
				out.close();
			} catch(Exception e2) {
			}
		}
	}
	
	protected void dispContents(AuthServletContext ct) throws StoreException {
		PrintWriter out = ct.out;
//		AuthUrl postArticleUrl = ct.authUrl;
		INaver inaver = ct.inaver;
		MasterStore store = ct.store;
		HttpSession session = ct.request.getSession(false);
		HttpServletRequest request = ct.request;

		UserConfig user = ct.user;

		int boardId = tonum(request.getParameter("b"));
		int nid = tonum(request.getParameter("id"));
		int artNo = tonum(request.getParameter("a"));
        String articleContent = request.getParameter("ArticleContent");

        Board board = store.queryBoard(boardId);
        
        NaverAccount account = (NaverAccount)session.getAttribute("naveraccount");
		
		if(account == null) {
			out.println("NAVERAJEg񂪐ݒ肳Ă܂");
			return;
		}
		
		NaverSession naverSession = (NaverSession)session.getAttribute("naversession");

		if(naverSession == null) {
			naverSession = new NaverSession(account.naverId, account.password);
			session.setAttribute("naversession", naverSession);
		}

		try {
			if(!naverSession.nowLogin()) {
				naverSession.login();
			}
		} catch(NetException e) {
			out.println("login failed: " + e.getMessage());
			Log.err(e);
			return;
		}

		try {
			naverSession.postArticle(board.boardName, nid, new String(articleContent.getBytes("iso-8859-1"), "Shift_JIS")	);
		} catch(NetException e) {
			out.println("post failed: " + e.getMessage());
			Log.err(e);
			return;
		} catch(UnsupportedEncodingException e) {
			out.println("post failed: " + e.getMessage());
			Log.err(e);
			return;
		}

        Log.info(user.userName + " post bid=" + boardId + " nid=" + nid);

        ThreadTitle threadSummary = store.queryThreadTitle(boardId, nid);
        HashSet<Poster> denyList = store.queryDenyList();
		ThreadCrawler crawler = new ThreadCrawler(store, board, threadSummary, new TaskStage(), true, denyList);
		inaver.getMasterScheduler().addUrgentTask(crawler);
		crawler.waitDone();

		if(crawler.exception != null) {
			out.println("successful written but update failedF " + crawler.exception.getMessage());		
		} else {
			ThreadUrl threadUrl = new ThreadUrl(request, user.pageArticleNum);

			String newUrl;

			newUrl = threadUrl.toString(ct.response) + "#" + artNo;

			out.println(
				"<html><head><meta http-equiv='Content-type' content='text/html; "
				+ "charset=Shift_JIS'><title>X</title>");
			out.println("<meta http-equiv=\"Refresh\" content=\"0; URL=" + newUrl + "\">");
			out.println("</head><body>");
			out.println("<a href=\"" + newUrl + " \">݌ʂ{</a>");
			out.println("</body></html>");
		}
		
	}
}
