/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.store;

import java.io.*;
import java.math.*;
import java.security.*;
import java.sql.*;
import java.util.*;

import javax.crypto.*;
import javax.crypto.spec.*;

import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

import com.aibonware.inaver.*;
import com.aibonware.inaver.model.*;
import com.aibonware.nvrlib.model.*;

public class MasterStoreImpl extends StoreBase implements MasterStore {
	private static Object updateSync = new Object();

	/**
	 * RXgN^B
	 */
	public MasterStoreImpl(String dbHost, String dbPass, String dbname) throws StoreException {
		super("master", dbHost, dbPass, dbname);
	}

	private String calcAuth(String userName, String password, String date) {
		try {
			MessageDigest md = MessageDigest.getInstance("MD5");
	
			md.update(userName.getBytes());
			md.update(password.getBytes());
			md.update(date.getBytes());
	
			return new BigInteger(md.digest()).abs().toString(16);
		} catch(NoSuchAlgorithmException e) {
			throw new RuntimeException(e);
		}
	}

	private String calcFastLoginAuth(String userName, String date, int seed) {
		try {
			MessageDigest md = MessageDigest.getInstance("MD5");

			md.update(userName.getBytes());
			md.update(date.getBytes());
			md.update(String.valueOf(seed).getBytes());
	
			return new BigInteger(md.digest()).abs().toString(16);
		} catch(NoSuchAlgorithmException e) {
			throw new RuntimeException(e);
		}
	}

	public UserConfig getUser(int userId) throws StoreException {
		try {
			ResultSet rs = sql.executeQuery("select * from Users where UserID=" + userId + "");
	
			if(!rs.next()) {
				rs.close();
				return null; // ̂܂Ȃ
			}

			String dateText = rs.getString("RegisterDate");
//			String srcAuth = rs.getString("Auth");
			String userName = rs.getString("userName");
			int minThreadNum = rs.getInt("MinThreadNum");
			int pageThreadNum = rs.getInt("PageThreadNum");
			int pageArticleNum = rs.getInt("PageArticleNum");
			int fastLinkSeed = rs.getInt("FastLinkSeed");
			int flags1 = rs.getInt("Flags1");
			int flags2 = rs.getInt("Flags2");
			String fastLoginAuth = rs.getString("FastLoginAuth");
            int converterType = rs.getInt("ConverterType");
			String lastLoginDate = rs.getString("LastLoginDate");

			long physicalFlags = ((long)flags1) + (((long)flags2) << 32);
			long logicalFlags = UserConfig.reverseNegativeBits(physicalFlags);

			rs.close();

			UserConfig user = new UserConfig(
				userId, 
				userName, 
				safer.sqlDatetimeToDate(dateText), 
				minThreadNum, 
				pageThreadNum,
				pageArticleNum,
				fastLinkSeed,
				logicalFlags,
				fastLoginAuth,
                converterType,
                safer.sqlDatetimeToDate(lastLoginDate));

			rs = sql.executeQuery("select * from FilterThreadPosters where UserID=" + userId);

			while(rs.next()) {
				user.addFilterThreadPoster(rs.getString("Poster"));
			}

			rs.close();

			rs = sql.executeQuery("select * from FilterArticlePosters where UserID=" + userId);

			while(rs.next()) {
				user.addFilterArticlePoster(rs.getString("Poster"));
			}

			rs.close();

			return user;

		} catch(SQLException e) {
			throw new StoreException(e);
		}
	}

	public void deleteUser(int userId) throws StoreException {
		try {
			sql.executeUpdate("delete from Users where UserID=" + userId);
			sql.executeUpdate("delete from FilterThreadPosters where UserID=" + userId);
			sql.executeUpdate("delete from FilterArticlePosters where UserID=" + userId);
			sql.executeUpdate("delete from NaverAccount where UserID=" + userId);
		} catch(SQLException e) {
			throw new StoreException(e);
		}
	}

	public Vector<UserConfig> getUserList() throws StoreException {
		Vector<UserConfig> list = new Vector<UserConfig>();

		try {
			Statement sql2 = con.createStatement();
			ResultSet users = sql.executeQuery("select * from Users");

			while(users.next()) {
				int userId = users.getInt("UserID");
				String dateText = users.getString("RegisterDate");
//				String srcAuth = users.getString("Auth");
				String userName = users.getString("userName");
				int minThreadNum = users.getInt("MinThreadNum");
				int pageThreadNum = users.getInt("PageThreadNum");
				int pageArticleNum = users.getInt("PageArticleNum");
				int fastLinkSeed = users.getInt("FastLinkSeed");
				int flags1 = users.getInt("Flags1");
				int flags2 = users.getInt("Flags2");
				String fastLoginAuth = users.getString("FastLoginAuth");
                int converterType = users.getInt("ConverterType");
				String lastLoginDate = users.getString("LastLoginDate");

				long physicalFlags = ((long)flags1) + (((long)flags2) << 32);
				long logicalFlags = UserConfig.reverseNegativeBits(physicalFlags);

				UserConfig user = new UserConfig(
					userId, 
					userName, 
					safer.sqlDatetimeToDate(dateText), 
					minThreadNum, 
					pageThreadNum,
					pageArticleNum,
					fastLinkSeed,
					logicalFlags,
					fastLoginAuth,
                    converterType,
	                safer.sqlDatetimeToDate(lastLoginDate));

				ResultSet filters = sql2.executeQuery("select * from FilterThreadPosters where UserID=" + userId);

				while(filters.next()) {
					user.addFilterThreadPoster(filters.getString("Poster"));
				}

				filters.close();

				filters = sql2.executeQuery("select * from FilterArticlePosters where UserID=" + userId);

				while(filters.next()) {
					user.addFilterArticlePoster(filters.getString("Poster"));
				}

				filters.close();

				list.addElement(user);
			}
			
			sql2.close();
			users.close();
			return list;

		} catch(SQLException e) {
			throw new StoreException(e);
		}
	}

	public UserConfig loginUser(String userName, String password) throws StoreException {
		try {
			ResultSet rs = sql.executeQuery("select * from Users where userName=\"" + userName + "\"");
	
			if(!rs.next()) {
				rs.close();
				return null;
			}

			int userId = rs.getInt("UserID");
			String dateText = rs.getString("RegisterDate");
			String srcAuth = rs.getString("Auth");
			String destAuth = calcAuth(userName, password, dateText);
			int minThreadNum = rs.getInt("MinThreadNum");
			int pageThreadNum = rs.getInt("PageThreadNum");
			int pageArticleNum = rs.getInt("PageArticleNum");
			int fastLinkSeed = rs.getInt("FastLinkSeed");
			int flags1 = rs.getInt("Flags1");
			int flags2 = rs.getInt("Flags2");
			String fastLoginAuth = rs.getString("FastLoginAuth");
            int converterType = rs.getInt("ConverterType");
			String lastLoginDate = rs.getString("LastLoginDate");

			long physicalFlags = ((long)flags1) + (((long)flags2) << 32);
			long logicalFlags = UserConfig.reverseNegativeBits(physicalFlags);

			rs.close();

			if(!destAuth.equals(srcAuth)) {
				return null;
			}

			UserConfig user = new UserConfig(
				userId, 
				userName, 
				safer.sqlDatetimeToDate(dateText), 
				minThreadNum, 
				pageThreadNum,
				pageArticleNum,
				fastLinkSeed,
				logicalFlags,
				fastLoginAuth,
                converterType,
	            safer.sqlDatetimeToDate(lastLoginDate));

			rs = sql.executeQuery("select * from FilterThreadPosters where UserID=" + userId);

			while(rs.next()) {
				user.addFilterThreadPoster(rs.getString("Poster"));
			}

			rs.close();

			rs = sql.executeQuery("select * from FilterArticlePosters where UserID=" + userId);

			while(rs.next()) {
				user.addFilterArticlePoster(rs.getString("Poster"));
			}

			rs.close();

			java.util.Date now = new java.util.Date();
			sql.executeUpdate("update Users set LastLoginDate=" + safer.datetime(now) + " where UserID=" + userId);
					
			return user;

		} catch(SQLException e) {
			throw new StoreException(e);
		}
	}

	public UserConfig fastLoginUser(String auth) throws StoreException {
		try {
			ResultSet rs = sql.executeQuery("select * from Users where FastLoginAuth=\"" + auth + "\"");
	
			if(!rs.next()) {
				rs.close();
				return null;
			}

			int userId = rs.getInt("UserID");
			String userName = rs.getString("UserName");
			String dateText = rs.getString("RegisterDate");
//			String srcAuth = rs.getString("Auth");
			int minThreadNum = rs.getInt("MinThreadNum");
			int pageThreadNum = rs.getInt("PageThreadNum");
			int pageArticleNum = rs.getInt("PageArticleNum");
			int fastLinkSeed = rs.getInt("FastLinkSeed");
			int flags1 = rs.getInt("Flags1");
			int flags2 = rs.getInt("Flags2");
			String fastLoginAuth = rs.getString("FastLoginAuth");
            int converterType = rs.getInt("ConverterType");
			String lastLoginDate = rs.getString("LastLoginDate");

			long physicalFlags = ((long)flags1) + (((long)flags2) << 32);
			long logicalFlags = UserConfig.reverseNegativeBits(physicalFlags);

			rs.close();

			UserConfig user = new UserConfig(
				userId, 
				userName, 
				safer.sqlDatetimeToDate(dateText), 
				minThreadNum, 
				pageThreadNum,
				pageArticleNum,
				fastLinkSeed,
				logicalFlags,
				fastLoginAuth,
                converterType,
	            safer.sqlDatetimeToDate(lastLoginDate));

			if(!user.fastLoginEnabled()) return null;

			rs = sql.executeQuery("select * from FilterThreadPosters where UserID=" + userId);

			while(rs.next()) {
				user.addFilterThreadPoster(rs.getString("Poster"));
			}

			rs.close();

			rs = sql.executeQuery("select * from FilterArticlePosters where UserID=" + userId);

			while(rs.next()) {
				user.addFilterArticlePoster(rs.getString("Poster"));
			}

			rs.close();

			java.util.Date now = new java.util.Date();
			sql.executeUpdate("update Users set LastLoginDate=" + safer.datetime(now) + " where UserID=" + userId);
					
			return user;

		} catch(SQLException e) {
			throw new StoreException(e);
		}
	}

	public String registerUser(String userName, String password, int rand) throws StoreException {
		try {
			ResultSet rs = sql.executeQuery("select count(*) as Count from Users where userName=\"" + userName + "\"");
			rs.next();
			int cnt = rs.getInt("Count");
			rs.close();
			
			if(cnt > 0) return "o^ς݂̃[UłBʂ̃[Uw肵ĂB<br>";
						
			String regDate = SQLSanitizer.datetimeFormatter.format(new java.util.Date());

			String auth = calcAuth(userName, password, regDate);
			String fastLoginAuth = calcFastLoginAuth(userName, regDate, rand);
	
			String sqlText = 
				"insert into Users values (null, "
				+ "\"" + userName + "\", "
				+"\"" + regDate + "\", "
				+"\"" + auth + "\", 0, 10, 10, " + rand + ", 0, \"" + fastLoginAuth + "\", 0, 0,"
				+"\"" + regDate + "\""
				+ ")";
				
			sql.executeUpdate(sqlText);

		} catch(SQLException e) {
			throw new StoreException(e);
		}

		return MasterStore.REGISTER_OK;
	}

	public void updateUserPassword(UserConfig user, String newPassword) throws StoreException {
		try {
			ResultSet rs = sql.executeQuery("select * from Users where UserID=" + user.userId);
			
			rs.next();
			String dateText = rs.getString("RegisterDate");
			rs.close();
			
			String newAuth = calcAuth(user.userName, newPassword, dateText);
			
			sql.executeUpdate("update Users set Auth=\"" + newAuth + "\" where UserID=" + user.userId);

		} catch(SQLException e) {
			throw new StoreException(e);
		}
	}

	public void updateUser(UserConfig user) throws StoreException {
		try {
			long physicalFlags = UserConfig.reverseNegativeBits(user.flags);
			int flags1 = (int)(physicalFlags & 0xffffffffL);
			int flags2 = (int)((physicalFlags >> 32) & 0xffffffffL);
			
			String sqlText = "update Users set ";

			sqlText = sqlText + "UserName=\"" + user.userName + "\", ";
//			sqlText = sqlText + "RegisterDate=\"" + SQLSanitizer.datetimeFormatter.format(user.registerDate) + "\" ";
			sqlText = sqlText + "MinThreadNum=" + user.minThreadNum + ", ";
			sqlText = sqlText + "PageThreadNum=" + user.pageThreadNum + ", ";
			sqlText = sqlText + "PageArticleNum=" + user.pageArticleNum + ", ";
			sqlText = sqlText + "Flags1=" + flags1 + ", ";
			sqlText = sqlText + "Flags2=" + flags2 + ", ";
            sqlText = sqlText + "ConverterType=" + user.converterType + ", ";
			sqlText = sqlText + "LastLoginDate=" + safer.datetime(user.lastLoginDate) + " ";

			sqlText = sqlText + " where UserID=" + user.userId;
			
			sql.executeUpdate(sqlText);

			sql.executeUpdate("delete from FilterThreadPosters where UserID=" + user.userId);
			sql.executeUpdate("delete from FilterArticlePosters where UserID=" + user.userId);

			for(int i=0; i<user.getFilterThreadPostersNum(); i++) {
				sql.executeUpdate(
					"insert into FilterThreadPosters values ("
					+ user.userId + ", " + safer.text(user.getFilterThreadPoster(i)) 
					+ ")");
			}
			
			for(int i=0; i<user.getFilterArticlePostersNum(); i++) {
				sql.executeUpdate(
					"insert into FilterArticlePosters values ("
					+ user.userId + ", " + safer.text(user.getFilterArticlePoster(i)) 
					+ ")");
			}
			
		} catch(SQLException e) {
			throw new StoreException(e);
		}
	}

	public int addDeleteRequest(int boardId, int threadId, String sReason) throws StoreException {
		try {
//			String requestDate = SQLSanitizer.datetimeFormatter.format(new java.util.Date());

			String sqlText = "insert into DelRequests values(" 
				+ "null, " 
				+ safer.text(sReason) + ", " 
				+ boardId + ", " 
				+ threadId + ", "
				+  safer.datetime(new java.util.Date()) + ", " 
				+  "null, " 
				+ DelRequest.DELSTAT_OPEN + ")";

			sql.executeUpdate(sqlText);
			
			ResultSet rs = sql.executeQuery(
				"select max(RequestID) as rid from DelRequests");

			rs.next();
			int requestId = rs.getInt("rid");

			rs.close();
			return requestId;

		} catch(SQLException e) {
			throw new StoreException(e);
		}
	}
	
	public Vector<DelRequest> queryDelRequestList() throws StoreException {
		Vector<DelRequest> v = new Vector<DelRequest>();
		
		try {
			ResultSet rs = sql.executeQuery(
				"select * from DelRequests order by BoardID, NID");

			while(rs.next()) {
				int requestID = rs.getInt("RequestID");
				String reason = rs.getString("Reason");
				int boardID = rs.getInt("BoardID");
				int nid = rs.getInt("NID");
				java.util.Date requestDate = safer.sqlDatetimeToDate(rs.getString("RequestDate"));
				java.util.Date processDate = safer.sqlDatetimeToDate(rs.getString("ProcessDate"));
				int status = rs.getInt("Status");

				v.addElement(new DelRequest(
					requestID,
					reason,
					boardID,
					nid,
					requestDate,
					processDate,
					status));
			}

			rs.close();
			return v;

		} catch(SQLException e) {
			throw new StoreException(e);
		}
	}
	
	public int getActiveDelRequestCount() throws StoreException {
		try {
			ResultSet rs = sql.executeQuery(
				"select count(*) as cnt from DelRequests where Status = " + DelRequest.DELSTAT_OPEN);

			rs.next();
			int count = rs.getInt("cnt");

			rs.close();
			return count;

		} catch(SQLException e) {
			throw new StoreException(e);
		}
	}

	public DelRequest queryDelRequest(int requestId) throws StoreException {
		try {
			ResultSet rs = sql.executeQuery(
				"select * from DelRequests where RequestID=" + requestId);

			if(!rs.next()) return null;

			int requestID = rs.getInt("RequestID");
			String reason = rs.getString("Reason");
			int boardID = rs.getInt("BoardID");
			int nid = rs.getInt("NID");
			java.util.Date requestDate = safer.sqlDatetimeToDate(rs.getString("RequestDate"));
			java.util.Date processDate = safer.sqlDatetimeToDate(rs.getString("ProcessDate"));
			int status = rs.getInt("Status");

			DelRequest req = new DelRequest(
				requestID,
				reason,
				boardID,
				nid,
				requestDate,
				processDate,
				status);

			rs.close();
			return req;

		} catch(SQLException e) {
			throw new StoreException(e);
		}
	}

	public void updateDelStatus(int requestId, int newStatus) throws StoreException {
		try {
			String sqlText = "update DelRequests set Status=" + newStatus + ", ProcessDate=" + safer.datetime(new java.util.Date()) + " where RequestID=" + requestId;
			sql.executeUpdate(sqlText);

		} catch(SQLException e) {
			throw new StoreException(e);
		}
	}
  
   
	private static byte[] encrpytionSignature = "encsig".getBytes();
	
	private String encryptNaverInfo(boolean doEncrypt, String password, String plainText) throws GeneralSecurityException {
		if(password == null || plainText == null || !doEncrypt) {
			return new BASE64Encoder().encode(plainText.getBytes()).replaceAll("\\r|\\n", "");
		}

		// 
		byte rand[] = new byte[16];
		new Random().nextBytes(rand);
		
		// ƃpX[h_CWFXǧvZ
		MessageDigest md = MessageDigest.getInstance("SHA-256");
		md.update(rand);
		md.update(password.getBytes());
		byte[] digest = md.digest();

		// _CWFXg献NV𐶐
		byte[] key = new byte[16];
		byte[] iv = new byte[16];

		System.arraycopy(digest, 0, key, 0, 16);
		System.arraycopy(digest, 16, iv, 0, 16);

		SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
		IvParameterSpec ivSpec = new IvParameterSpec(iv);

		// Í
		Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
		cipher.init(Cipher.ENCRYPT_MODE, keySpec,ivSpec);
		byte[] headerBytes = cipher.update(encrpytionSignature);
		byte[] remainBytes = cipher.doFinal(plainText.getBytes());

		// ƈÍ
		ByteArrayOutputStream envelope = new ByteArrayOutputStream();
		envelope.write(rand, 0, rand.length);
		if(headerBytes != null) envelope.write(headerBytes, 0, headerBytes.length);
		envelope.write(remainBytes, 0, remainBytes.length);

		// BASE64GR[hĕԋp
		return new BASE64Encoder().encode(envelope.toByteArray()).replaceAll("\\r|\\n", "");
	}

	private String decryptNaverInfo(boolean doEncrypt, String password, String encodedCipherText) throws GeneralSecurityException, IOException, StoreException {
		if(password == null || encodedCipherText == null || !doEncrypt) return new String(new BASE64Decoder().decodeBuffer(encodedCipherText));

		// BASE64fR[h
		byte[] decodedCipherText = new BASE64Decoder().decodeBuffer(encodedCipherText);
		
		// ƈÍ̐؂蕪
		ByteArrayInputStream envelope = new ByteArrayInputStream(decodedCipherText);
		byte[] rand = new byte[16];
		byte[] cipherBytes = new byte[decodedCipherText.length - rand.length];

		envelope.read(rand);
		envelope.read(cipherBytes);
		
		// _CWFXǧvZ
		MessageDigest md = MessageDigest.getInstance("SHA-256");
		md.update(rand);
		md.update(password.getBytes());
		byte[] digest = md.digest();
		
		// _CWFXg献IV𐶐
		byte[] key = new byte[16];
		byte[] iv = new byte[16];

		System.arraycopy(digest, 0, key, 0, 16);
		System.arraycopy(digest, 16, iv, 0, 16);

		SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
		IvParameterSpec ivSpec = new IvParameterSpec(iv);

		// 
		Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
		cipher.init(Cipher.DECRYPT_MODE, keySpec,ivSpec);
		byte[] clearBytes = cipher.doFinal(cipherBytes);
		
		// Íwb_ƕ{؂蕪
		envelope = new ByteArrayInputStream(clearBytes);
		byte[] headerBytes = new byte[encrpytionSignature.length];
		byte[] remainBytes = new byte[clearBytes.length - headerBytes.length];
		envelope.read(headerBytes);
		envelope.read(remainBytes);

		// Íwb_̂ł邱ƂmF
		for(int i=0; i<encrpytionSignature.length; i++) {
			if(encrpytionSignature[i] != headerBytes[i]) throw new StoreException("invalid encryption signature");
		}
		
		// ʂԋp
		return new String(remainBytes);
	}
	
	private static Object naverAccountSync = new Object();

	public void updateNaverAccount(int userId, boolean doEncrypt, String nvrPassword, String naverId, String password, String articlePassword) throws StoreException {
		synchronized(naverAccountSync) {
			try {
				ResultSet rs = sql.executeQuery("select * from NaverAccount where UserID=" + userId);
				
				if(rs.next()) {
					String sqlText = 
						"update NaverAccount set "
						+ "DoEncrypt=" + safer.bool(doEncrypt) + ", "
						+ "NaverID=" + safer.text(encryptNaverInfo(doEncrypt, nvrPassword, naverId)) + ", "
						+ "Password=" + safer.text(encryptNaverInfo(doEncrypt, nvrPassword, password)) + ", "
						+ "ArticlePassword=" + safer.text(encryptNaverInfo(doEncrypt, nvrPassword, articlePassword)) + " "
						+ "where UserID=" + userId;
	
					sql.executeUpdate(sqlText);
				} else {
					String sqlText = 
						"insert into NaverAccount values ("
						+ userId +", "
						+ safer.bool(doEncrypt) + ", "
						+ safer.text(encryptNaverInfo(doEncrypt, nvrPassword, naverId)) + ", "
						+ safer.text(encryptNaverInfo(doEncrypt, nvrPassword, password)) + ", "
						+ safer.text(encryptNaverInfo(doEncrypt, nvrPassword, articlePassword))
						+ ")";
	
					sql.executeUpdate(sqlText);
				}
				
				rs.close();
				
			} catch(GeneralSecurityException e) {
				throw new StoreException(e);
			} catch(SQLException e) {
				throw new StoreException(e);
			}
		}
	}
	
	public NaverAccount queryNaverAccount(int userId, String nvrPassword) throws StoreException {
		try {
			ResultSet rs = sql.executeQuery("select * from NaverAccount where UserID=" + userId + "");
	
			if(!rs.next()) {
				rs.close();
				return null; 
			}
			
			boolean doEncrypt = safer.sqlBool(rs.getString("DoEncrypt"));

			String naverId = decryptNaverInfo(doEncrypt, nvrPassword, rs.getString("NaverID"));
			String password = decryptNaverInfo(doEncrypt, nvrPassword, rs.getString("Password"));
			String articlePassword = decryptNaverInfo(doEncrypt, nvrPassword, rs.getString("ArticlePassword"));

			rs.close();

			if(doEncrypt && nvrPassword == null) return null;
			NaverAccount naverAccount = new NaverAccount(naverId, password, articlePassword);

			return naverAccount;

		} catch(IOException e) {
			Log.err(e);
			return null;
		} catch(GeneralSecurityException e) {
			Log.err(e);
			return null;
		} catch(SQLException e) {
			Log.err(e);
			throw new StoreException(e);
		}
	}

	public void updateArticles(int boardId, int nid, ArticleList articleList, int lastArticleId) throws StoreException {
		synchronized(updateSync) {
			try {
				Log.info("update(a) bid=" + boardId + " nid=" + nid);

				// Ō̃XIDȍ~̃Xf[^x[XɊi[
				java.util.Date lastArticleDate = insertArticles(sql, boardId, nid, articleList, lastArticleId);

				// ŏIXtXV
				if(lastArticleDate != null) {
					sql.executeUpdate("update Threads set LastArticleDate= " + safer.datetime(lastArticleDate) + " where BoardID=" + boardId + " and NID=" + nid);
				}
			
	//			int max = getLastArticleId(thread.nid);
			
			} catch(SQLException e) {
				throw new StoreException(e);
			}
		}
	}
	
	/**
	 * Xbh̓eXVB
	 * lbg[NERec̓G[ꍇAOo͂AIB
	 * @param sql
	 * @param threadSummary
	 */
	public void updateThread(int boardId, String contents, String rawContents, NThread thread, ArticleList articleList, int lastArticleId) throws StoreException {
		synchronized(updateSync) {
			try {
				Log.info("update bid=" + boardId + " nid=" + thread.nid);

				// Ō̃XIDȍ~̃Xf[^x[XɊi[
				java.util.Date lastArticleDate = insertArticles(sql, boardId, thread.nid, articleList, lastArticleId);

				// Rec̓eXV					
				try {
					String sqlText =
						"update Threads set Content=" + safer.text(contents) 
						+ ", RawContent=" + safer.text(rawContents) 
						+ ", ImageURL=" + safer.text(thread.imageUrl);

					if(thread.isHot) sqlText = sqlText + ", IsHot='1'";

					sqlText = sqlText + " where BoardID=" + boardId + " and NID=" + thread.nid;
					
					sql.executeUpdate(sqlText);
				} catch(SQLException e) {
					Log.err(e);
					Log.err("contents can not store");
					
					sql.executeUpdate("update Threads set Content=\"#contents_error\", RawContent=\"#contents_error\" where BoardID=" + boardId + " and NID=" + thread.nid);
				}


				// ݂̎ۂ̃X擾
				ResultSet rs = sql.executeQuery("select count(*) as cnt from Articles where BoardID=" + boardId + " and NID=" + thread.nid);
				rs.next();
				int actualArticleNum = rs.getInt("cnt");
				rs.close();
			
				// \L̃X<ۂ̃XȂAVKX͎ۂ̃Xɂ
				// (uցv\ȂȂǂ̏Q̑Ώj
				int newArticleNum;
				if(actualArticleNum > thread.articleNum) newArticleNum = actualArticleNum;
				else newArticleNum = thread.articleNum;

				// XXV
				sql.executeUpdate("update Threads set ArticleNum= " + newArticleNum + " where BoardID=" + boardId + " and NID=" + thread.nid);
	
                // ꎞX擾tOfalseɂ
                sql.executeUpdate("update Threads set IsTemp= " + safer.bool(false) + " where BoardID=" + boardId + " and NID=" + thread.nid);
                
                
				// ŏIXtXV
				if(lastArticleDate != null) {
					sql.executeUpdate("update Threads set LastArticleDate= " + safer.datetime(lastArticleDate) + " where BoardID=" + boardId + " and NID=" + thread.nid);
				}
			
	//			int max = getLastArticleId(thread.nid);
			
			} catch(SQLException e) {
				throw new StoreException(e);
			}
		}
	}

	public void updateBoardCrawlTime(Board board) throws StoreException {
		try {
			java.util.Date now = new java.util.Date();
			sql.executeUpdate("update Boards set LastCrawlTime= " + safer.datetime(now) + " where BoardID=" + board.boardId);
		} catch(SQLException e) {
			throw new StoreException(e);
		}
	}

	public void updateThreadCrawlTime(int boardId, NThread thread) throws StoreException {
		try {
			java.util.Date now = new java.util.Date();
			sql.executeUpdate("update Threads set LastCrawlTime=" + safer.datetime(now) + " where BoardID=" + boardId + " and NID=" + thread.nid);
		} catch(SQLException e) {
			throw new StoreException(e);
		}
	}

	/**
	 * Xbh̓ef[^x[XɊi[B
	 * lbg[NERec̓G[ꍇAOo͂AIB
	 * @param sql
	 * @param threadSummary
	 */
	public void insertThread(int boardId, String contents, String rawContents, NThread thread, ArticleList articleList) throws StoreException {
		try {
			Log.info("new bid=" + boardId + " nid=" + thread.nid);

			// XQf[^x[XɊi[
			java.util.Date lastArticleDate = insertArticles(sql, boardId, thread.nid, articleList, -1);

			if(lastArticleDate == null) {
				lastArticleDate = thread.createDate;
			}

			// Xbh̓ef[^x[XɊi[
			insertFields(sql, "Threads",  new String[][] {
				{"NID",                     safer.num(thread.nid)},
				{"BoardID",                 safer.num(boardId)},
				{"DispID",                  safer.text(thread.dispId)},
				{"Depth",                   safer.num(thread.depth)},
				{"Country",                 safer.num(thread.country)},
				{"ArticleNum",              safer.num(thread.articleNum)},
				{"IsAdmin",                 safer.bool(thread.isAdminThread)},
				{"Poster",                  safer.text(thread.poster)},
				{"CreateDate",              safer.datetime(thread.createDate)},
				{"ModifiedDate",            safer.datetime(thread.modifiedDate)},
				{"LastArticleDate",         safer.datetime(lastArticleDate)},
				{"ViewNum",                 safer.num(thread.viewNum)},
				{"Mail",                    safer.text(thread.mail)},
				{"LastCrawlTime",           safer.datetime(thread.lastCrawlTime)},
				{"LastSuccessfulCrawlTime", null},
				{"CrawlFailCount",          safer.num(0)},
				{"Title",                   safer.text(thread.title)},
//				{"Content",                 safer.text(contents)},
                {"Traffic",                 safer.num(0)},
                {"IsTemp",                  safer.bool(false)},
                {"ImageURL",                safer.text(thread.imageUrl)},
                {"IsHot",                   safer.bool(thread.isHot)},
			});

			// Rec̓eXV					
			try {
				sql.executeUpdate("update Threads set Content=" + safer.text(contents) + ", RawContent=" + safer.text(rawContents) + " where BoardID=" + boardId + " and NID=" + thread.nid);
			} catch(SQLException e) {
				Log.err(e);
				Log.err("contents can not store");
				
				sql.executeUpdate("update Threads set Content=\"#contents_error\" where BoardID=" + boardId + " and NID=" + thread.nid);
			}
		
			// Xbheef[^x[XɊi[
/*			String sqlText = "insert into RawThreadContents values("
				+ safer.num(thread.nid) + ", " + safer.text(contents) + ")";
		
			sql.executeUpdate(sqlText);
*/		

		} catch(SQLException e) {
			throw new StoreException(e);
		}
	}

	/**
	 * Xbh́Amax傫XIDXAf[^x[XɊi[B
	 * @param sql
	 * @param thread i[郌XQێXbhB
	 * @param max 
	 * @throws SQLException
	 */
	private java.util.Date insertArticles(Statement sql, int boardId, int nid, ArticleList articleList, int max) throws SQLException {
		java.util.Date lastArticleDate = null;

		// eXɂĊi[JԂ
		for(int articleNo=0; articleNo<articleList.getArticleCount(); articleNo++) {
			Article art = articleList.getArticle(articleNo);
			
			// XIDw肳ꂽmax傫ȂAe[uփXi[B
			if(art.articleId > max) {
				insertFields(sql, "Articles", new String[][] {
					{"ArticleID", safer.num(art.articleId)},
					{"NID", safer.num(nid)},
					{"BoardID", safer.num(boardId)},
					{"Author", safer.text(art.author)},
					{"Country", safer.num(art.country)},
					{"PostTime", safer.datetime(art.postDate)},
//					{"Content", safer.text(art.content)},
					{"ParentArticleID", safer.num(art.parentArticleId)},
				});
				
				// Rec̓eXV					
				try {
					sql.executeUpdate("update Articles set Content=" + safer.text(art.content) + " where BoardID=" + boardId + " and NID=" + nid + " and ArticleID=" + art.articleId);
				} catch(SQLException e) {
					Log.err(e);
					Log.err("contents can not store");
				
					sql.executeUpdate("update Articles set Content=\"#contents_error\" where BoardID=" + boardId + " and NID=" + nid + " and ArticleID=" + art.articleId);
				}
				
				if(lastArticleDate == null) {
					lastArticleDate = art.postDate;
				} else if(lastArticleDate.compareTo(art.postDate) < 0) {
					lastArticleDate = art.postDate;
				}
			}
			
			// ɂ́AzN̍lKv
		}

		return lastArticleDate;
	}


	/**
	 * e[uɈs}
	 * @param sql
	 * @param tableName
	 * @param fields
	 * @throws SQLException
	 */
	private void insertFields(Statement sql, String tableName, String[][] fields) throws SQLException {
		String sqlText = "insert into " + tableName + " (";
		String delim = "";
				
		for(int j=0; j<fields.length; j++) {
			sqlText = sqlText + delim + fields[j][0];
			delim = ", ";
		}

		sqlText = sqlText + ") values (";
		delim = "";
				
		for(int j=0; j<fields.length; j++) {
			sqlText = sqlText + delim + fields[j][1];
			delim = ", ";
		}

		sqlText = sqlText + ")";
		sql.executeUpdate(sqlText);
	}

	public void updateThreadTraffic(int boardId, int nid, int trafficToAdd) throws StoreException {
        try {
            sql.executeUpdate("update Threads set Traffic = Traffic +" + trafficToAdd + " where BoardID=" + boardId + " and NID=" + nid);
        } 
        catch(SQLException e) {
            throw new StoreException(e);
        }
    }
	
	public HashSet<Poster> queryDenyList() throws StoreException {
        try {
        	HashSet<Poster> denyList = new HashSet<Poster>();
        	
        	ResultSet rs = sql.executeQuery("select * from DenyList");
        	
        	while(rs.next()) {
        		String name = rs.getString("Name");
        		int country = rs.getInt("Country");
        		
        		denyList.add(new Poster(name, country));
        	}
        	
        	rs.close();
        	return denyList;
        } 
        catch(SQLException e) {
            throw new StoreException(e);
        }		
	}
}
