/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.store;

import java.util.*;

import com.aibonware.inaver.model.*;
import com.aibonware.nvrlib.model.*;

public class StoreLogger implements MasterStore {
	private MasterStoreImpl master;
	private BackupStore backup;
	
	public String getDBName() {
		return master.getDBName();
	}
	
	public StoreLogger(String dbHost, String dbPass, String dbname, BackupStore backup) throws StoreException {
		master = new MasterStoreImpl(dbHost, dbPass, dbname);
		this.backup = backup;
	}

	public void close() throws StoreException {
		master.close();
	}

	public BoardList queryBoardList(boolean mustVisible, boolean mustCrawlable) throws StoreException {
		return master.queryBoardList(mustVisible, mustCrawlable);
	}

	public Board queryBoard(int srcBoardId) throws StoreException {
		return master.queryBoard(srcBoardId);
	}

	public ThreadList queryThreadList(
			int boardId, 
			int start, 
			int num, 
			String[] topPosters,
			boolean newThreadToTop,
			int minArticleNum,
			Vector<String> delPosters) throws StoreException {
		return master.queryThreadList(boardId, start, num, topPosters, newThreadToTop, minArticleNum, delPosters);
	}

	public int queryThreadListOnLogMode(
			int boardId, 
			int start, 
			int num, 
			ThreadList threadList) throws StoreException {
		return master.queryThreadListOnLogMode(boardId, start, num, threadList);
	}

	public ArticleList queryArticleList(int boardId, int nid, int start, int num, Vector<String> delPosters) throws StoreException {
		return master.queryArticleList(boardId, nid, start, num,  delPosters);
	}

	public ThreadDiff getThreadDiff(int boardId, ThreadTitle threadSummary) throws StoreException {
		return master.getThreadDiff(boardId, threadSummary);
	}
	
	public int getLastArticleId(int boardId, int nid) throws StoreException {
		return master.getLastArticleId(boardId, nid);
	}

	public String queryThreadContents(int boardId, int nid) throws StoreException {
		return master.queryThreadContents(boardId, nid);
	}

	public String queryRawThreadContents(int boardId, int nid) throws StoreException {
		return master.queryRawThreadContents(boardId, nid);
	}
	
 	public NThread queryThread(int boardId, int nid) throws StoreException {
		return master.queryThread(boardId, nid);
 	}

 	public ThreadTitle queryThreadTitle(int boardId, int nid) throws StoreException {
		return master.queryThreadTitle(boardId, nid);
 	}

 	public boolean existsThread(int boardId, int threadId) throws StoreException {
		return master.existsThread(boardId, threadId);
 	}
 	
	public int queryThreadTraffic(int boardId, int nid) throws StoreException {
		return master.queryThreadTraffic(boardId, nid);
 	}

	public UserConfig getUser(int userId) throws StoreException {
		return master.getUser(userId);
 	}

	public void deleteUser(int userId) throws StoreException {
		master.deleteUser(userId);
 	}

	public Vector<UserConfig> getUserList() throws StoreException {
		return master.getUserList();
 	}

	public UserConfig loginUser(String userName, String password) throws StoreException {
		return master.loginUser(userName, password);
 	}

	public UserConfig fastLoginUser(String auth) throws StoreException {
		return master.fastLoginUser(auth);
 	}

	public String registerUser(String userName, String password, int rand) throws StoreException {
		return master.registerUser(userName, password, rand);
 	}

	public void updateUser(UserConfig user) throws StoreException {
		master.updateUser(user);
 	}

	public void updateUserPassword(UserConfig user, String newPassword) throws StoreException {
		master.updateUserPassword(user, newPassword);
	}
	
	public int addDeleteRequest(int boardId, int threadId, String sReason) throws StoreException {
		return master.addDeleteRequest(boardId, threadId, sReason);
 	}

	public Vector<DelRequest> queryDelRequestList() throws StoreException {
		return master.queryDelRequestList();
 	}

	public int getActiveDelRequestCount() throws StoreException {
		return master.getActiveDelRequestCount();
 	}

	public DelRequest queryDelRequest(int requestId) throws StoreException {
		return master.queryDelRequest(requestId);
 	}

	public void updateDelStatus(int requestId, int newStatus) throws StoreException {
		master.updateDelStatus(requestId, newStatus);
 	}

	public void updateNaverAccount(int userId, boolean doEncrypt, String nvrPassword, String naverId, String password, String articlePassword) throws StoreException {
		master.updateNaverAccount(userId, doEncrypt, nvrPassword, naverId, password, articlePassword);
 	}

	public NaverAccount queryNaverAccount(int userId, String nvrPassword) throws StoreException {
		return master.queryNaverAccount(userId, nvrPassword);
 	}

	public void updateBoardCrawlTime(Board board) throws StoreException {
		master.updateBoardCrawlTime(board);
 	}

// ȉOΏ

	public void updateThread(int boardId, String contents, String rawContents, NThread thread, ArticleList articleList, int lastArticleId) throws StoreException {
		backup.addThreadLog(BackupStore.THREAD_UPDATE, boardId, thread.nid);
		master.updateThread(boardId, contents, rawContents, thread, articleList, lastArticleId);
 	}

	public void updateArticles(int boardId, int nid, ArticleList articleList, int lastArticleId) throws StoreException {
		backup.addThreadLog(BackupStore.THREAD_UPDATE, boardId, nid);
		master.updateArticles(boardId, nid, articleList, lastArticleId);
	}

	public void updateThreadCrawlTime(int boardId, NThread thread) throws StoreException {
		backup.addThreadLog(BackupStore.THREAD_UPDATE, boardId, thread.nid);
		master.updateThreadCrawlTime(boardId, thread);
 	}

	public void insertThread(int boardId, String contents, String rawContents, NThread thread, ArticleList articleList) throws StoreException {
		backup.addThreadLog(BackupStore.THREAD_UPDATE, boardId, thread.nid);
		master.insertThread(boardId, contents, rawContents, thread, articleList);
 	}

	public void deleteThread(int boardId, int nid) throws StoreException {
		backup.addThreadLog(BackupStore.THREAD_DELETE, boardId, nid);
		master.deleteThread(boardId, nid);
 	}

	public void updateThreadTraffic(int boardId, int nid, int trafficToAdd) throws StoreException {
		backup.addThreadLog(BackupStore.THREAD_UPDATE, boardId, nid);
		master.updateThreadTraffic(boardId, nid, trafficToAdd);
 	}
	
	public HashSet<Poster> queryDenyList() throws StoreException {
		return master.queryDenyList();
	}

	public ArticleFullPathList queryNewArticles(int boardId, int num) throws StoreException {
		return master.queryNewArticles(boardId, num);
	}
}

