/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.task;

import EDU.oswego.cs.dl.util.concurrent.*;
import com.aibonware.inaver.*;
import com.aibonware.nvrlib.web.*;

/**
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public class CrawlerResumeTask extends ResumeableTask {
	private long time = 0;
	private Mutex sync = new Mutex();
	
	private static class CrawlerResumeStage extends TaskStage {
		public int sessionCount = 0;
		public WebSession lastSession = null;
		
		public CrawlerResumeStage() {}

		public void afterStage() {
			Scheduler crawlerResumer = INaver.getInstance().getCrawlerResumer();
			crawlerResumer.addTask(new CrawlerResumeTask());
		}
	}
	
	private static CrawlerResumeStage crawlerResumeStage = new CrawlerResumeStage();
	
	public CrawlerResumeTask() {
		super(crawlerResumeStage);

		try {
			sync.acquire();
		} catch(InterruptedException e) {}
	}

	public void execute() {
		try {
			long start = System.currentTimeMillis();
			boolean suspended = sync.attempt(60 * 1000);
			long end = System.currentTimeMillis();

			if(suspended) {
				time = time - (end - start);
				if(time < 10) time = 10;
			}

			WebSession session = INaver.getInstance().getCurrentWebSession();
	
			if(crawlerResumeStage.lastSession == null) Log.info("last session is null");
			if(session == null) Log.info("current session is null");

			if(session == null || crawlerResumeStage.lastSession == null || session != crawlerResumeStage.lastSession) {
				crawlerResumeStage.lastSession = session;
				crawlerResumeStage.sessionCount = 0;
				Log.info("check hangup...not hangup");
			} else {
				crawlerResumeStage.lastSession = session;
				crawlerResumeStage.sessionCount++;
				
				Log.info("hangup count=" + crawlerResumeStage.sessionCount);
				
				if(crawlerResumeStage.sessionCount >= 5) {
					Log.info("close session");
					try {
						session.close();
					} catch(java.io.IOException e) {
						Log.err("IOException occurred in CrawlerResumeTask");
					}
					Log.info("close complete");
					
					crawlerResumeStage.lastSession = null;
					crawlerResumeStage.sessionCount = 0;
				}
			}
		} catch(InterruptedException e) {}
	}

	public void suspend() {
		sync.release();
	}
}
