/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.task;

import java.util.*;
import java.text.*;

public class TimeKeeper {
	private final Calendar workDateTime;
	private static final SimpleDateFormat workDateFormat = new SimpleDateFormat("yyyy.MM.dd");
	public static final int workHour = 6;

	public TimeKeeper(String workDateText) throws ParseException {
		Date workDate = workDateFormat.parse(workDateText);
		workDateTime = new GregorianCalendar();
		workDateTime.setTime(workDate);
		workDateTime.add(Calendar.HOUR, workHour);
	}

	public Calendar getWorkDateTime() {
		return workDateTime;
	}

	public DateRange getLastDailyDateRange() {
		Calendar endDateTime = (Calendar)workDateTime.clone();
		endDateTime.set(Calendar.HOUR, 0);

		Calendar startDateTime = (Calendar)endDateTime.clone();
		startDateTime.add(Calendar.DATE, -1);
		
		return new DateRange(workDateTime, startDateTime, endDateTime);
	}
	
	public DateRange getLastWeeklyDateRange() {
		Calendar endDateTime = (Calendar)workDateTime.clone();
		endDateTime.set(Calendar.HOUR, 0);
		endDateTime.set(Calendar.DAY_OF_WEEK, Calendar.SUNDAY);
		
		Calendar startDateTime = (Calendar)endDateTime.clone();
		startDateTime.add(Calendar.WEEK_OF_MONTH, -1);
		
		return new DateRange(workDateTime, startDateTime, endDateTime);
	}
	
	public DateRange getLastMonthlyDateRange() {
		Calendar endDateTime = (Calendar)workDateTime.clone();
		endDateTime.set(Calendar.HOUR, 0);
		endDateTime.set(Calendar.DAY_OF_MONTH, 1);

		Calendar startDateTime = (Calendar)endDateTime.clone();
		startDateTime.add(Calendar.MONTH, -1);
		
		return new DateRange(workDateTime, startDateTime, endDateTime);
	}
}
