/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.task;

import java.io.*;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.*;

import com.aibonware.inaver.*;
import com.aibonware.inaver.store.*;
import com.aibonware.nvrlib.model.*;

// ŐVXꗗXV
public class UpdateArticleListTask extends Task {
	private static SimpleDateFormat df = new SimpleDateFormat("MM/dd HH:mm");

	private SQLCanceler canceler;
	volatile public boolean canceled = false;
	volatile public Exception exception = null;
	volatile public Vector<ArticleFullPath> articles = null;
	private final Board board;

    public UpdateArticleListTask(Board board) {
    	this.board = board;
    	
        canceler = new SQLCanceler() {
            private Statement sql;
            
            public void setStatement(Statement sql) {
                this.sql = sql;
            }

            public void cancel() {
                try {
                    sql.cancel();
                } catch(SQLException e) {
                    Log.err("cancel operation failed");
                    Log.err(e);
                }
            }
        };
     }

    public void execute() {
        try {
            if(!canceled) {
    	    	SQLStoreProvider provider = INaver.getInstance().getStoreProvider();

    	    	Log.info("begin alist board=" + board.boardId);
    	    	
    	    	// }X^XgA擾ׂCfbNX𒣂ĂȂ߃obNAbvXgA擾
    	    	BackupStore store = provider.openBackupStore();
    	    	ArticleFullPathList articles = store.queryNewArticles(board.boardId, Env.getEnv().newArtNum);
    	    	store.close();

    	    	String outFileName = Env.getEnv().rlistDir + board.boardName + ".html"; 

    			PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outFileName), "MS932")));

    			out.println(
    				"<html><head><meta http-equiv='Content-type' content='text/html; "
    				+ "charset=Shift_JIS'><title>VX" + Env.getEnv().newArtNum + "</title></head><body>");

    			out.println("<b>" + board.dispName + "</b><br>");
    			
    	    	for(int i=0; i<articles.getArticleCount(); i++) {
    	    		ArticleFullPath art = articles.getArticle(i);
    	
    	    		String url = INaver.getInstance().getWebStore().getThreadUrlForLink(board, art.nid);

    				out.print("" + (i + 1) + ".");
    				out.print("<a href=\"" + url + "\">" + art.nid + "</a> ");
    				out.print(df.format(art.postDate) + " ");

					out.print(INaver.getCountryHtml(art.country) + " <b>" + art.author + "</b> ");

    				out.println(art.content + "<br>");    	  
    			}
    	    	
    			out.println("</body></html>");

    			out.close();
    			Log.info("end alist " + board.boardId);
            }
        } catch(Exception e) {
            exception = e;
        }
    }

    public void cancel() {
        canceler.cancel();
        canceled = true;
    }
}
