/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.url;

import java.util.*;
import javax.servlet.http.*;
import org.w3c.dom.*;
import com.aibonware.inaver.model.*;
import com.aibonware.inaver.conv.*;

/**
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public class SearchUrl extends PageUrl {
	public static final int TARGET_NONE = 0;
	public static final int TARGET_ARTICLE = 1;
	public static final int TARGET_THREAD = 2;
	public static final int TARGET_TITLE = 3;

	public final String author;
	public final int boardId;
	public final String keywords;
	public final int target;
	public final int country;
	public final int range;
	
	public SearchUrl(int loginMode) {
		super("search", loginMode, 0, 0, 0);

		author = null;
		boardId = 0;
		keywords = null;
		country = 0;
		target = 0;
        range = 1;
	}

	public SearchUrl(HttpServletRequest request, int itemNum) {
		super("search", request,itemNum);

		String sBoardId = request.getParameter("b");
		String author = request.getParameter("author");
		String keywords = toValidKeywords(request.getParameter("keywords"));
		String sType = request.getParameter("target");
		String sCountry = request.getParameter("country");
        String sAllLog = request.getParameter("r");
		
		if("thread".equals(sType)) target = TARGET_THREAD;
		else if("article".equals(sType)) target = TARGET_ARTICLE;
		else if("thread_title".equals(sType)) target = TARGET_TITLE;
		else target = TARGET_NONE;

		this.boardId = tonum(sBoardId);
		this.author = author;
		this.keywords = keywords;
		this.country = tonum(sCountry);
        this.range = tonum(sAllLog);
	}
	
	private final String toValidKeywords(String keywordsText) {
		try {
			if(keywordsText == null) keywordsText = "";
			keywordsText = new String(keywordsText.getBytes("iso-8859-1"), "Shift_JIS");
		} catch(Exception e) {
			com.aibonware.inaver.Log.err(e);
		}

		return keywordsText;
	}

	protected void addParamXML(Document doc, Element root) {
		root.appendChild(createAttr(doc, "Target", target));
		root.appendChild(createAttr(doc, "Author", author));
		root.appendChild(createAttr(doc, "Keywords", keywords));
		root.appendChild(createAttr(doc, "BoardID", boardId));
		root.appendChild(createAttr(doc, "Country", country));
		root.appendChild(createAttr(doc, "Range", range));
		
		super.addParamXML(doc, root);
	}

	public SearchUrl(Element root) {
		super("search", root);
		
		this.target = getIntAttr(root, "Target");
		this.boardId = getIntAttr(root, "BoardID");
		this.author = getStringAttr(root, "Author");
		this.keywords = getStringAttr(root, "Keywords");
		this.country = getIntAttr(root, "Country");
        range = getIntAttr(root, "Range");
	}
	
	protected void addParamStrings(Vector<String> params) {
		if(target == TARGET_THREAD) params.addElement("target=thread");
		else if(target == TARGET_ARTICLE) params.addElement("target=article");
		else if(target == TARGET_TITLE) params.addElement("target=thread_title");
		
		if(author != null && !author.equals("")) params.addElement("author=" + author);
		if(keywords != null && !keywords.equals("")) params.addElement("keywords=" + keywords);
		if(boardId > 0) params.addElement("b=" + boardId);
		if(country > 0) params.addElement("country=" + country);
        if(range > 0) params.addElement("r=" + range);

		super.addParamStrings(params);
	}

	public ThreadUrl getThreadTopUrl(UserConfig user, int boardId, int nid) {
		return new ThreadUrl(loginMode, 0, user.pageArticleNum-1, boardId, nid, user.pageThreadNum, 0, ContentsConverter.CONVERTER_TYPE_DEFAULT);
	}

	// itemNum0ŋ̂Ŏb...
	public String next(HttpServletResponse response) {
		PageUrl url = (PageUrl)copy();
		int n = url.end - url.start + 1;
		if(n < 1) n=1;
		url.start = this.end + 1;
		url.end = url.start + n - 1;

		return url.toString(response);
	}
}
