/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.nvrlib.model;

import java.util.*;
import org.w3c.dom.*;

public class ArticleFullPathList extends XMLNode {
	private Vector<ArticleFullPath> articles = new Vector<ArticleFullPath>();
	
	public ArticleFullPathList() {}
	
	public ArticleFullPathList(Element root) {
		NodeList nodes = root.getChildNodes();
		
		for(int i=0; i<nodes.getLength(); i++) {
			if(nodes.item(i).getNodeName().equals("ArticleFullPath")) {
				articles.addElement(new ArticleFullPath((Element)nodes.item(i)));
			}
		}
	}

	public int getArticleCount() {
		return articles.size();
	}

	public void addArticle(ArticleFullPath article) {
		articles.addElement(article);
	}
	
	public ArticleFullPath getArticle(int index) {
		return (ArticleFullPath)articles.elementAt(index);
	}

	public void reverse() {
		Vector<ArticleFullPath> revObjects = new Vector<ArticleFullPath>();

		for(int i=articles.size()-1; i>=0; i++) {
			revObjects.addElement(articles.elementAt(i));
		}

		articles = revObjects;
	}
	
	public Element toXML(Document doc) {
		Element root = doc.createElement("ArticleFullPathList");

		for(int i=0; i<articles.size(); i++) {
			root.appendChild(articles.elementAt(i).toXML(doc));
		}
		
		return root;
	}
}
