/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.nvrlib.model;

import java.util.*;

/**
 * NaverTCgŜ\NXB
 * {NX͔̈ꗗێB̈ꗗݒ肳ꂽCX^X擾ɂ́A
 * WebProvider#getSite()ĂяoB
 */
public class BoardList {
	private Vector<Board> boards = new Vector<Board>();
	
	/**
	 * RXgN^Bw肳ꂽޔB
	 * @param siteUrl NaverTCgURL
	 */
	public BoardList() {}

	/**
	 * ǉB
	 * @param board ǉB
	 */
	public void addBoard(Board board) {
		boards.addElement(board);
	}
	
	/**
	 * ̐擾B
	 * @return ̐B
	 */	
	public int getBoardCount() {
		return boards.size();
	}
	
	/**
	 * 擾B
	 * @param index 擾̃CfbNXB
	 * @return B
	 */
	public Board getBoard(int index) {
		return (Board)boards.elementAt(index);
	}
	
	public Board getBoardById(int boardId) {
		for(int i=0; i<getBoardCount(); i++) {
			Board board = getBoard(i);
			if(board.boardId == boardId) return board;
		}
		
		return null;
	}
	
	public int getIndexFromId(int boardId) {
		for(int i=0; i<getBoardCount(); i++) {
			Board board = getBoard(i);
			if(board.boardId == boardId) return i;
		}

		return -1;
	}
	
	/**
	 * w肳ꂽ擾BOs̏ꍇARuntimeExceptionX[B
	 * @param boardName ̓B
	 * @return B
	 */
	public Board getBoard(String boardName) {
		for(int i=0; i<boards.size(); i++) {
			Board board = (Board)getBoard(i);
			if(boardName.equals(board.boardName)) return board;
		}
		
		throw new RuntimeException("invalid board name" + boardName);
	}
}
