/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.nvrlib.web;

//import java.net.MalformedURLException;
import java.io.*;
//import org.apache.commons.httpclient.*;
//import org.apache.commons.httpclient.methods.*;

import com.aibonware.nvrlib.model.*;
import com.aibonware.nvrlib.parser.*;
import com.aibonware.nvrlib.*;

/**
 * NaverTCgWeby[Wǂݍ݁Ả͌ʂԋpB
 * WebXXNX̃CX^X͑SāA{NXA܂͖{NXɂĐꂽCX^X
 * qCX^XƂĎ擾\B
 * {NX̃CX^XgINaverێB
 */
public class WebStore {
//	private final BoardListProvider boardListProvider;
	private AppTools appTools;
	
	/**
	 * RXgN^BȂB
	 */
	public WebStore(AppTools appTools) {
		this.appTools = appTools;
//		this.boardListProvider = appTools.getBoardListProvider();
	}

	public void close() {}

	/**
	 * WebSiteCX^X擾B擾́Af[^x[XǂݍށB
	 * @return WebSiteCX^XB
	 * @throws StoreException f[^x[X񂪎擾łȂB
	 */
/*	public BoardList queryBoardList(boolean onlyVisible) throws BoardListException {
		Object session = boardListProvider.open();
		BoardList boardList = boardListProvider.queryBoardList(session, onlyVisible);
		boardListProvider.close(session);

		return boardList;
	}
*/
	public ThreadTitleList queryBoardPage(Board board, int pageNo) throws ParsingException, NetException {
		String url = getBoardPageUrl(board, pageNo);

		BoardPageParser parser = new ParserProvider(appTools).getBoardPageParser(board, url);
		ThreadTitleList page = parser.parse();

		return page;
	}

	public WebThreadContents queryWebThreadContents(Board board, int nid, ThreadTitle templateThread) throws ParsingException, NetException {
		String url = getThreadUrlForCrawl(board, nid);

		WebSession session = WebStore.getWebSession(appTools, url);
		BufferedReader reader = session.getReader();

		ThreadParser parser = new ParserProvider(appTools).getThreadParser(board, reader, templateThread);
		parser.parse();
		ArticleList articleList = parser.getResultArticleList();

		try {
			session.close();
		} catch(IOException e) {
			throw new RuntimeException("URLN[Ys", e);
		}

		return new WebThreadContents(parser.getResultRawContents(), articleList, parser.getResultThread());
	}

	public String getSiteUrl() {
		return appTools.getNaverBaseUrl();
	}

	public String getBoardUrl(Board board) {
		return getSiteUrl() + "tbbs/list.php?board_id=" + board.boardName;
	}

	public String getBoardPageUrl(Board board, int pageNo) {
		if(pageNo == 1) {
			return getBoardUrl(board);
		} else {
			return getBoardUrl(board) + "&page=" + pageNo;
		}
	}

	public String getThreadUrlForCrawl(Board board, int nid) {
		return getSiteUrl() + "tbbs/read.php?board_id=" + board.boardName + "&nid=" + nid + "&chk_poll=YES";
	}
	
	public String getThreadUrlForLink(Board board, int nid) {
		return getSiteUrl() + "tbbs/read.php?board_id=" + board.boardName + "&nid=" + nid;
	}
	
	public static String text(String s) {
		StringBuffer buf = new StringBuffer(s.length()*2);
		int len = s.length();

		for(int i=0; i<len; i++) {
			char c = s.charAt(i);
			
			switch(c) {
				case '"': buf.append("&quot;"); break;
				case '&': buf.append("&amp;"); break;
				case '<': buf.append("&lt;"); break;
				case '>': buf.append("&gt;"); break;
				case ' ': buf.append("&nbsp;"); break;
				default: buf.append(c); 
			}
		}

		return buf.toString();
	}

	public static WebSession getWebSession(AppTools appTools, String urlString) throws NetException {
	
		try {
			WebSession session = new HttpClientWebSession(appTools, urlString);
			session.open();
			return session;

		} catch(UnsupportedEncodingException e) {
			throw new RuntimeException("MS932GR[hT|[g", e);
		} catch(IOException e) {
			throw new NetException(e);
		}
	}
}

