package com.aibonware.viewnaver.browser.win32;

public class URLPolicy {
	public static final int URLPOLICY_ACTIVEX_CHECK_LIST = 0x00010000;
	public static final int URLPOLICY_CREDENTIALS_SILENT_LOGON_OK = 0x00000000;
	public static final int URLPOLICY_CREDENTIALS_MUST_PROMPT_USER = 0x00010000;
	public static final int URLPOLICY_CREDENTIALS_CONDITIONAL_PROMPT = 0x00020000;
	public static final int URLPOLICY_CREDENTIALS_ANONYMOUS_ONLY = 0x00030000;
	public static final int URLPOLICY_AUTHENTICATE_CLEARTEXT_OK = 0x00000000;
	public static final int URLPOLICY_AUTHENTICATE_CHALLENGE_RESPONSE = 0x00010000;
	public static final int URLPOLICY_AUTHENTICATE_MUTUAL_ONLY = 0x00030000;
	public static final int URLPOLICY_JAVA_PROHIBIT = 0x00000000;
	public static final int URLPOLICY_JAVA_HIGH = 0x00010000;
	public static final int URLPOLICY_JAVA_MEDIUM = 0x00020000;
	public static final int URLPOLICY_JAVA_LOW = 0x00030000;
	public static final int URLPOLICY_JAVA_CUSTOM = 0x00800000;
	public static final int URLPOLICY_CHANNEL_SOFTDIST_PROHIBIT = 0x00010000;
	public static final int URLPOLICY_CHANNEL_SOFTDIST_PRECACHE = 0x00020000;
	public static final int URLPOLICY_CHANNEL_SOFTDIST_AUTOINSTALL = 0x00030000;
	public static final int URLPOLICY_ALLOW = 0x00;
	public static final int URLPOLICY_QUERY = 0x01;
	public static final int URLPOLICY_DISALLOW = 0x03;
	public static final int URLPOLICY_NOTIFY_ON_ALLOW = 0x10;
	public static final int URLPOLICY_NOTIFY_ON_DISALLOW = 0x20;
	public static final int URLPOLICY_LOG_ON_ALLOW = 0x40;
	public static final int URLPOLICY_LOG_ON_DISALLOW = 0x80;
	public static final int URLPOLICY_DONTCHECKDLGBOX = 0x100;

	public final String name;
	public final int policy;

	private URLPolicy(int policy, String name) {
		this.name = name;
		this.policy = policy;
	}

	public String toString() {
		return name;
	}

	public static final URLPolicy ALLOW = new URLPolicy(URLPOLICY_ALLOW, "");
	public static final URLPolicy DISALLOW = new URLPolicy(URLPOLICY_DISALLOW, "~");

	public static final URLPolicy JAVA_PROHIBIT = new URLPolicy(URLPOLICY_JAVA_PROHIBIT, "~");
	public static final URLPolicy JAVA_HIGH = new URLPolicy(URLPOLICY_JAVA_PROHIBIT, "sandbox");

	public static final URLPolicy CHANNEL_SOFTDIST_PROHIBIT = new URLPolicy(URLPOLICY_CHANNEL_SOFTDIST_PROHIBIT, "~");
	public static final URLPolicy CHANNEL_SOFTDIST_PRECACHE = new URLPolicy(URLPOLICY_CHANNEL_SOFTDIST_PRECACHE , "LbV");

	public static final URLPolicy CREDENTIALS_MUST_PROMPT_USER = new URLPolicy(URLPOLICY_CREDENTIALS_MUST_PROMPT_USER, "₢킹");
	public static final URLPolicy CREDENTIALS_SILENT_LOGON_OK = new URLPolicy(URLPOLICY_CREDENTIALS_SILENT_LOGON_OK , "OC");
}
