/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.command;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.content.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.window.*;

@SuppressWarnings("serial")
public class PosterMenuItemCreator {
	public PosterMenuItemCreator() {
	}

	private Window searchParentWindow(Container container) {
		for (;;) {
			container = container.getParent();
			if (container instanceof Window)
				return (Window) container;
		}
	}

	public void addPosterMenuItems(final TabContentView contentView, final PosterSelection posterSelection, JPopupMenu popup) {
		final JMenuItem sendMessageMenu = new JMenuItem(new AbstractAction("bZ[WM") {
			public void actionPerformed(ActionEvent e) {
				Poster poster = posterSelection.getCurrentPoster();
				if (poster == null)
					return;

				WriteMessageWindow messageWindow = new WriteMessageWindow(ViewNaver.instance.mainWindow, poster.name, poster.country, "");

				messageWindow.setVisible(true);
			}
		});

		final JMenuItem idJitenMenu = new JMenuItem(new AbstractAction("IDT...") {
			public void actionPerformed(ActionEvent e) {
				Poster poster = posterSelection.getCurrentPoster();
				if (poster == null)
					return;

				IDJitenList idJiten = ViewNaver.instance.idJiten;
				if (idJiten == null)
					return;

				String explain = idJiten.getExplain(poster);

				if (explain != null) {
					IDJitenWindow idwindow = IDJitenWindow
							.createIDJitenWindow(PosterMenuItemCreator.this.searchParentWindow(contentView), poster.name, explain);

					// Point mousePoint =
					// MouseInfo.getPointerInfo().getLocation();
					// idwindow.setLocation(mousePoint.x, mousePoint.y);
					idwindow.setLocation(100, 100);

					idwindow.setVisible(true);
				}

			}
		});

		final JMenuItem favMenu = new JMenuItem(new AbstractAction("CɓIDɒǉ") {
			public void actionPerformed(ActionEvent e) {
				Poster poster = posterSelection.getCurrentPoster();
				if (poster == null)
					return;

				ViewNaver.instance.config.favoritePersonConfig.persons.add(poster);

				contentView.refreshContent();
			}
		});

		final JMenuItem filterMenu = new JMenuItem(new AbstractAction("̨ݸ") {
			public void actionPerformed(ActionEvent e) {
				Poster poster = posterSelection.getCurrentPoster();
				if (poster == null)
					return;

				ViewNaver.instance.config.filterConfig.filters.put(new Poster(poster.name, poster.country), FilterType.Visible);

				contentView.refreshContent();
			}
		});

		final JMenuItem hiddenFilterMenu = new JMenuItem(new AbstractAction("̨ݸ") {
			public void actionPerformed(ActionEvent e) {
				Poster poster = posterSelection.getCurrentPoster();
				if (poster == null)
					return;

				ViewNaver.instance.config.filterConfig.filters.put(new Poster(poster.name, poster.country), FilterType.Hidden);

				contentView.refreshContent();
			}
		});

		idJitenMenu.setEnabled(false);

		popup.add(sendMessageMenu);
		popup.add(idJitenMenu);
		popup.add(favMenu);
		popup.add(filterMenu);
		popup.add(hiddenFilterMenu);

		posterSelection.addPosterSelectionListener(new PosterSelectionListener() {
			public void selected(Poster poster) {
				if (poster == null) {
					idJitenMenu.setEnabled(false);
				}

				IDJitenList idJiten = ViewNaver.instance.idJiten;

				if (idJiten == null || idJiten.getExplain(poster) == null) {
					idJitenMenu.setEnabled(false);
				} else {
					idJitenMenu.setEnabled(true);
				}

			}
		});
	}
}
