/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.command;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.content.*;
import com.aibonware.viewnaver.content.thread.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.task.*;

public class ShowThreadCommand extends GUITask {
//	public final NThread threadTitle;
	public final String threadTitle;
	public final String poster;
	public final String boardName;
	public final int nid;

	public ShowThreadCommand(NThread threadTitle, String boardName) {
		this.threadTitle = threadTitle.title;
		this.poster = threadTitle.poster;
		this.boardName = boardName;
		this.nid = threadTitle.nid;
	}

	public ShowThreadCommand(String boardName, int nid, String poster, String threadTitle) {
		this.threadTitle = threadTitle;
		this.poster = poster;
		this.boardName = boardName;
		this.nid = nid;
	}
	
	public ShowThreadCommand(String boardName, int nid) {
		this.poster = null;
		this.threadTitle = null;
		this.boardName = boardName;
		this.nid = nid;
	}

	public void exec() {
		TabContainerView containerView =  ViewNaver.instance.threadWindow.threadListView;
		TabContentCategory category;
		
		if(threadTitle == null || poster == null) {
			category = ThreadContent.getCategory(boardName, nid);
		} else {
			category = ThreadContent.getCategory(boardName, nid, poster, threadTitle);
		}

		new ShowThreadWindowCommand().run();
		
		taskFlow.clear();
		containerView.update(category);
	}
}
