/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.config;

import java.awt.*;
import javax.swing.*;
import org.w3c.dom.*;

@SuppressWarnings("serial")
public class CapacityConfig extends ConfigItem {
	public int maxBoardPageCache = 10;
	public int maxCompositeThreadCache = 300;
	public int maxStorageThreads = 1000;

	public CapacityConfig() {
		super("Capacity");
		loadConfig(null);
	}

	@Override public void loadConfig(Element elem) {
		maxBoardPageCache = Config.getIntConfig(elem, "MaxBoardPageCache", 10);
		maxCompositeThreadCache = Config.getIntConfig(elem, "MaxCompositeThreadCache", 300);
		maxStorageThreads = Config.getIntConfig(elem, "MaxStorageThreads", 1000);
	}

	@Override public void saveConfig(Element elem) {
		Config.setIntConfig(elem, "MaxBoardPageCache", maxBoardPageCache);
		Config.setIntConfig(elem, "MaxCompositeThreadCache", maxCompositeThreadCache);
		Config.setIntConfig(elem, "MaxStorageThreads", maxStorageThreads);
	}

	@Override public String getDispPath() {
		return "e";
	}

	private static class CapacityConfigView extends ConfigItemView {
		JTextField maxBoardPageCacheText;
		JTextField maxCompositeThreadCacheText;
		JTextField maxStorageThreadsText;
		
		private CapacityConfig capacityConfig;

		public CapacityConfigView() {
			Dimension maxTextFieldSize = new Dimension(1000, 20);

			maxBoardPageCacheText = new JTextField();
			maxBoardPageCacheText.setMaximumSize(maxTextFieldSize);
			
			maxCompositeThreadCacheText = new JTextField();
			maxCompositeThreadCacheText.setMaximumSize(maxTextFieldSize);
			
			maxStorageThreadsText = new JTextField();
			maxStorageThreadsText.setMinimumSize(maxTextFieldSize);
			
			addLine(
				"Ƃ̃LbVy[WF\t", glue(maxBoardPageCacheText), "\n",
				"Ƃ̃XbheLbVXbhF\t", glue(maxCompositeThreadCacheText), "\n",
				"Ƃ̃XbhOۊǐF\t", glue(maxStorageThreadsText));
		}

		public void setConfig(ConfigItem config) {
			capacityConfig = (CapacityConfig)config;

			maxBoardPageCacheText.setText(String.valueOf(capacityConfig.maxBoardPageCache));
			maxCompositeThreadCacheText.setText(String.valueOf(capacityConfig.maxCompositeThreadCache));
			maxStorageThreadsText.setText(String.valueOf(capacityConfig.maxStorageThreads));
		}

		public void applyConfig() throws ConfigException {
			try {
				capacityConfig.maxBoardPageCache = Integer.parseInt(maxBoardPageCacheText.getText());
				capacityConfig.maxCompositeThreadCache = Integer.parseInt(maxCompositeThreadCacheText.getText());
				capacityConfig.maxStorageThreads = Integer.parseInt(maxStorageThreadsText.getText());
			} catch(NumberFormatException e) {
				throw new ConfigException("lw肵ĂB");
			}
		}
	}

	@Override public ConfigItemView getView() {
		return new CapacityConfigView();
	}

}
