/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.config;

import java.io.*;
import java.util.*;

import javax.xml.parsers.*;
import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.stream.*;

import org.w3c.dom.*;
import org.xml.sax.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.model.*;

public class Config extends ConfigItem {
	private Vector<ConfigUser> clients = new Vector<ConfigUser>();
	
//	public Map<Poster, Boolean> filters = new HashMap<Poster, Boolean>();

	public String httpAgentName = "viewNVR beta version - enjoyKOREA Browser";

	public NetworkConfig network;
	public ArticleTemplateConfig articleTemplate;
	public FilterConfig filterConfig;
	public FavoritePersonConfig favoritePersonConfig;
	public CapacityConfig capacityConfig;
	public SearchConfig searchConfig;
	public BoardConfig boardConfig;
	
	public Config() {
		super("Configuration");

		addChild(network = new NetworkConfig());
		addChild(articleTemplate = new ArticleTemplateConfig());
		addChild(filterConfig = new FilterConfig());
		addChild(favoritePersonConfig = new FavoritePersonConfig());
		addChild(capacityConfig = new CapacityConfig());
		addChild(boardConfig = new BoardConfig());
		addChild(searchConfig = new SearchConfig());
	}

	public void loadFile(String fileName) {
		FileInputStream in;

		try {
			in = new FileInputStream(fileName); 
		} catch(FileNotFoundException e) {
			ViewNaver.println("ݒt@C܂łBftHglgp܂B");
			fireConfigureChanged();
			return;
		}

		try {
			ViewNaver.println("ݒt@C̓ǂݍݒ...");
			DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = dbfactory.newDocumentBuilder();
			Document doc = builder.parse(new BufferedInputStream(in));

			Element root = doc.getDocumentElement();
			loadConfigTree(root);
			
			fireConfigureChanged();
			ViewNaver.println("ݒt@C̓ǂݍ݊B");
		} catch(IOException e) {
			ViewNaver.err(e);
		} catch(ParserConfigurationException e) {
			ViewNaver.err(e);
		} catch(SAXException e) {
			ViewNaver.err(e);
		}
	}
	
	public void saveFile(String fileName) {
		try {
			ViewNaver.println("ݒt@C̏o...");
		
			DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = dbfactory.newDocumentBuilder();
	
			Document doc = builder.newDocument();

			Element root = doc.createElement(configName);
			doc.appendChild(root);

			saveConfigTree(root);

			TransformerFactory factory = TransformerFactory.newInstance();
			Transformer transformer = factory.newTransformer();
			
			transformer.setOutputProperty(OutputKeys.METHOD, "xml");
			transformer.setOutputProperty(OutputKeys.INDENT, "yes");

			transformer.transform(new DOMSource(root.getOwnerDocument()), new StreamResult("config.xml"));

			ViewNaver.println("ݒt@C̏oB");

		} catch(ParserConfigurationException e) {
			ViewNaver.err(e);
		} catch(TransformerConfigurationException e) {
			ViewNaver.err(e);
		} catch(TransformerException e) {
			ViewNaver.err(e);
		}
	}

	public void fireConfigureChanged() {
		for(int i=0; i<clients.size(); i++) {
			clients.elementAt(i).configChanged(this);
		}
	}
	
	public void addConfigUser(ConfigUser client) {
		clients.addElement(client);
	}
	
	public ConfigItem getAncestor(String configPath) {
		ConfigItem curConfig = this;

		StringTokenizer tokens = new StringTokenizer(configPath, ".");

		if(tokens.hasMoreTokens()) {
			String token = tokens.nextToken();
			curConfig = getChildByName(token);

			if(curConfig == null) {
				ViewNaver.println("sȐݒ荀ڃpXF " + configPath);
				return null;
			}
		}
		
		return curConfig;
	}

	public void addAncestor(String configPath, ConfigItem item) {
		ConfigItem cur = this;

		StringTokenizer tokens = new StringTokenizer(configPath, ".");

		if(tokens.hasMoreTokens()) {
			String token = tokens.nextToken();
			ConfigItem next = getChildByName(token);

			if(next == null) {
				next = new EmptyConfigItem(token);
				cur.addChild(next);
			}
			
			cur = next;
		}

		cur.addChild(item);
	}

	public static int getIntConfig(Element root, String configName, int defaultValue) {
		if(root == null) return defaultValue;
		
		NodeList children = root.getElementsByTagName(configName);

		if(children.getLength() == 0) return defaultValue;
		String valueText = children.item(0).getTextContent();
		
		try {
			return Integer.parseInt(valueText);
		} catch(NumberFormatException e) {
			return defaultValue;
		}
	}

	public static void setIntConfig(Element root, String configName, int value) {
		NodeList children = root.getElementsByTagName(configName);

		Element elem;
		
		if(children.getLength() == 0) {
			Document doc = root.getOwnerDocument();
			elem = doc.createElement(configName);
			root.appendChild(elem);
		} else {
			elem = (Element)children.item(0);
		}

		elem.setTextContent(String.valueOf(value));
	}
	
	public static String getStringConfig(Element root, String configName, String defaultValue) {
		if(root == null) return defaultValue;
		
		NodeList children = root.getElementsByTagName(configName);

		if(children.getLength() == 0) return defaultValue;
		return  children.item(0).getTextContent();
	}

	public static void setStringConfig(Element root, String configName, String value) {
		NodeList children = root.getElementsByTagName(configName);

		Element elem;
		
		if(children.getLength() == 0) {
			Document doc = root.getOwnerDocument();
			elem = doc.createElement(configName);
			root.appendChild(elem);
		} else {
			elem = (Element)children.item(0);
		}

		elem.setTextContent(value);
	}

	public static boolean getBooleanConfig(Element root, String configName, boolean defaultValue) {
		if(root == null) return defaultValue;
		
		NodeList children = root.getElementsByTagName(configName);

		if(children.getLength() == 0) return defaultValue;
		return Boolean.TRUE.toString().equalsIgnoreCase(children.item(0).getTextContent());
	}

	public static void setBooleanConfig(Element root, String configName, boolean value) {
		NodeList children = root.getElementsByTagName(configName);

		Element elem;
		
		if(children.getLength() == 0) {
			Document doc = root.getOwnerDocument();
			elem = doc.createElement(configName);
			root.appendChild(elem);
		} else {
			elem = (Element)children.item(0);
		}

		elem.setTextContent(Boolean.toString(value));
	}
	
	public static Poster getPosterConfig(Element root, String configName) {
		Poster broken = new Poster("broken configuration", Country.UNKNOWN);
		
		if(root == null) return broken;
		
		NodeList children = root.getElementsByTagName(configName);

		if(children.getLength() == 0) return broken;

		Element posterElem = (Element)children.item(0);

		String name = getStringConfig(posterElem, "Name", broken.name);
		String countryText = getStringConfig(posterElem, "Country", broken.country.name());

		return new Poster(name, Country.valueOf(countryText));
	}

	public static void setPosterConfig(Element root, String configName, Poster value) {
		Element posterElem = makeSureElement(root, configName);
		Element nameElem = makeSureElement(posterElem, "Name");
		Element countryElem = makeSureElement(posterElem, "Country");

		nameElem.setTextContent(value.name);
		countryElem.setTextContent(value.country.name());
	}
	
	private static Element makeSureElement(Element parent, String elementName) {
		NodeList children = parent.getElementsByTagName(elementName);

		Element elem;

		if(children.getLength() == 0) {
			Document doc = parent.getOwnerDocument();
			elem = doc.createElement(elementName);
			parent.appendChild(elem);
		} else {
			elem = (Element)children.item(0);
		}
		
		return elem;
	}
}
